/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.dynamicobject;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILongDataProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DataEntityPropertyChangedEventArgs;
import kd.bos.dataentity.metadata.dynamicobject.DynamicMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.ConvertUtils;

@KSObject
@SdkPublic
public class DynamicProperty
extends DynamicMetadata
implements IDataEntityProperty,
ILongDataProperty,
Serializable,
Cloneable {
    private static final Log log = LogFactory.getLog(DynamicProperty.class);
    private static final long serialVersionUID = 3957866699136368994L;
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String SPAN_TYPE_DYNAMICPROPERTY = "DynamicProperty";
    private static final String SPAN_TAG_PROPERTY = "prop";
    private static final String SPAN_TAG_DT = "dt";
    private static final String SPAN_TAG_DATAENTITY = "dataentity";
    private static final Log logger = LogFactory.getLog(DynamicProperty.class);
    public static final int DEFAULTORDINAL = -1;
    protected String _name;
    private String _alias = "";
    private LocaleString displayName;
    protected Class<?> _propertyType;
    IDataEntityType _parent;
    protected Object _defaultValue;
    protected boolean _hasDefaultValue;
    protected boolean _isReadonly;
    @Deprecated
    protected Integer _cachedHashcode;
    protected int _ordinal = -1;
    private int nullBit = -1;
    private int bitPos = -1;
    private Map<String, Object> customProperties = new ConcurrentHashMap<String, Object>();

    public DynamicProperty() {
    }

    protected DynamicProperty(String name, Class<?> propertyType, Object defaultValue, boolean isReadonly) {
        if (!DynamicProperty.IsValidIdentifier(name)) {
            throw new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("name:%s\u4e0d\u7b26\u5408\u89c4\u8303\u3002", "DynamicProperty_0", BOS_DATAENTITY, new Object[0]), name));
        }
        if (propertyType == null) {
            throw new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("propertyType\u4e0d\u80fd\u4e3a\u7a7a", "DynamicProperty_1", BOS_DATAENTITY, new Object[0]), new Object[0]));
        }
        this._name = name;
        this._propertyType = propertyType;
        this._defaultValue = defaultValue;
        this._isReadonly = isReadonly;
        this._hasDefaultValue = this.InnerHasDefaultValue();
    }

    private boolean InnerHasDefaultValue() {
        if (this._defaultValue == null) {
            return false;
        }
        if (this._propertyType == Integer.class ? this._defaultValue.equals(0) : (this._propertyType == Long.class ? this._defaultValue.equals(0L) : this._propertyType == BigDecimal.class && this._defaultValue.equals(new BigDecimal(0)))) {
            return false;
        }
        return this._defaultValue != null;
    }

    private static boolean IsValidIdentifier(String name) {
        return !StringUtils.isEmpty(name);
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    @KSMethod
    public boolean getReadOnly() {
        return this._isReadonly;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    @DefaultValueAttribute(value="")
    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    public LocaleString getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocaleString name) {
        this.displayName = name;
    }

    @Override
    public Class<?> getPropertyType() {
        return this._propertyType;
    }

    public final Object getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Object value) {
        this._defaultValue = value;
        this._hasDefaultValue = this.InnerHasDefaultValue();
    }

    @Override
    public final boolean hasDefaultValue() {
        return this._hasDefaultValue;
    }

    public final boolean getIsReadOnly() {
        return this._isReadonly;
    }

    @Override
    @KSMethod
    public final int getOrdinal() {
        return this._ordinal;
    }

    public final void setOrdinal(int value) {
        if (this._ordinal != value && this.isUnmodifiable()) {
            logger.info(this.getClass().getSimpleName() + " Ordinal is changed. old Ordinal :" + this._ordinal + " new Ordinal:" + value);
        }
        this._ordinal = value;
    }

    public final DynamicProperty findTrueProperty(DynamicObject dataEntity) {
        if (dataEntity == null) {
            throw new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u5bfb\u627e\u5b9e\u4f53\u4e0a%s\u5bf9\u5e94\u7684\u5c5e\u6027\u63cf\u8ff0\u7b26\u5931\u8d25\uff0c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DynamicProperty_2", BOS_DATAENTITY, new Object[0]), this.getName()));
        }
        DynamicObjectType dt = dataEntity.getDynamicObjectType();
        if (this.getParent() == dt) {
            return this;
        }
        DataEntityPropertyCollection properties = dt.getProperties();
        DynamicProperty find = (DynamicProperty)properties.get(this.getName());
        if (find != null) {
            return find;
        }
        for (Object p : dataEntity.getDynamicObjectType().getProperties()) {
            if (p.getName() == null || !p.getName().equals(this.getName())) continue;
            return (DynamicProperty)p;
        }
        StringBuilder sb = new StringBuilder();
        for (IDataEntityProperty p : dataEntity.getDynamicObjectType().getProperties()) {
            sb.append(p.getName()).append(" ");
        }
        ORMArgInvalidException e = new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u5bfb\u627e\u5b9e\u4f53\u4e0a%s\u5bf9\u5e94\u7684\u5c5e\u6027\u63cf\u8ff0\u7b26\u5931\u8d25\uff0c\u5b9e\u4f53\u4e0d\u5b58\u5728\u6b64\u5c5e\u6027\uff01", "DynamicProperty_3", SubSystemType.BOS, new Object[0]), this.getName()) + String.format("[EntityType\uff1a%1$s Propeyties:%2$s]", dataEntity.getDynamicObjectType().getName(), sb.toString()));
        HashMap<String, Object> tags = new HashMap<String, Object>(3);
        tags.put(SPAN_TAG_PROPERTY, this);
        tags.put(SPAN_TAG_DT, dataEntity.getDynamicObjectType());
        tags.put(SPAN_TAG_DATAENTITY, dataEntity);
        EntityTracer.throwException(SPAN_TYPE_DYNAMICPROPERTY, "findTrueProperty", null, e, tags);
        throw e;
    }

    public Object getDTValueFast(DynamicObject dataEntity) {
        Object localValue = dataEntity.getDataStorage().getLocalValue(this);
        if (localValue == null) {
            return this.getDefaultValue();
        }
        return localValue;
    }

    public final <T> T getDTValue(DynamicObject dataEntity) {
        DynamicProperty find = this.findTrueProperty(dataEntity);
        return (T)find.getDTValueFast(dataEntity);
    }

    @Override
    @KSMethod
    public Object getValue(Object dataEntity) {
        DynamicObject obj = this.convertToDynamicObject(dataEntity);
        return this.getDTValue(obj);
    }

    @Override
    @KSMethod
    public Object getValueFast(Object dataEntity) {
        DynamicObject obj = this.convertToDynamicObject(dataEntity);
        return this.getDTValueFast(obj);
    }

    @KSMethod
    public final void setDTValue(DynamicObject dataEntity, Object newValue) {
        DynamicProperty find = this.findTrueProperty(dataEntity);
        find.setValuePrivate(dataEntity, newValue);
    }

    @KSMethod
    public void setDTValueFast(DynamicObject dataEntity, Object newValue) {
        this.setValuePrivate(dataEntity, newValue);
    }

    public final void resetDTValue(DynamicObject dataEntity) {
        DynamicProperty find = this.findTrueProperty(dataEntity);
        find.resetValuePrivate(dataEntity);
    }

    private void resetValuePrivate(DynamicObject dataEntity) {
        if (this._isReadonly) {
            throw new OrmException("DynamicProperty.ResetValuePrivate", "ReadOnlyException");
        }
        Object newValue = this._defaultValue;
        this.setValuePrivate(dataEntity, newValue);
    }

    @SdkInternal
    protected void setValuePrivate(DynamicObject dataEntity, Object newValue) {
        if (this._isReadonly) {
            throw new OrmException("DynamicProperty.SetValuePrivate", "ReadOnlyException");
        }
        Object oldValue = null;
        if (!dataEntity.isInitializing()) {
            oldValue = dataEntity.getDataStorage().getLocalValue(this);
        }
        if (dataEntity.isInitializing() || oldValue == null || !this.isValueEquals(newValue, oldValue)) {
            Class<?> pType;
            Class<?> newValueType;
            if (newValue != null && this.isTypeNotEquals(newValueType = newValue.getClass(), pType = this.getPropertyType())) {
                if (StringUtils.isBlank(newValue)) {
                    newValue = pType.equals(Date.class) ? null : (pType.equals(BigDecimal.class) ? Integer.valueOf(0) : ConvertUtils.convert((Object)newValue, pType));
                } else if (pType.equals(Date.class) && newValueType.equals(Integer.class)) {
                    long longTime = Long.parseLong(String.valueOf((Integer)newValue));
                    newValue = ConvertUtils.convert((Object)longTime, pType);
                } else if (pType.equals(Date.class) && newValueType.equals(String.class)) {
                    if (this.isNumeric(newValue.toString())) {
                        long longTime = Long.parseLong(newValue.toString());
                        newValue = ConvertUtils.convert((Object)longTime, pType);
                    } else {
                        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                        try {
                            newValue = df.parse(newValue.toString());
                        }
                        catch (ParseException e) {
                            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("setvalue fail,name: %s ,value: %s, errmsg:", this.getName(), newValue) + e.getMessage()});
                        }
                    }
                } else {
                    newValue = ConvertUtils.convert((Object)newValue, pType);
                }
            }
            if (newValue == null || newValue.equals(this.getDefaultValue())) {
                dataEntity.getDataStorage().setLocalValue(this, null);
            } else {
                dataEntity.getDataStorage().setLocalValue(this, newValue);
            }
            this.onPropertyChanged(dataEntity, newValue, oldValue);
        }
    }

    private boolean isNumeric(String s) {
        if (s != null && !"".equals(s.trim())) {
            return s.matches("^\\d*$");
        }
        return false;
    }

    protected void onPropertyChanged(DynamicObject dataEntity, Object newValue, Object oldValue) {
        boolean isChange = false;
        if (dataEntity.isResetDirtyFlag()) {
            isChange = dataEntity.isResetDirtyFlag();
        } else {
            Object v1 = oldValue == null ? this.getDefaultValue() : oldValue;
            Object v2 = newValue == null ? this.getDefaultValue() : newValue;
            boolean bl = isChange = !dataEntity.isInitializing() && !this.isValueEquals(v1, v2);
        }
        if (isChange) {
            DataEntityPropertyChangedEventArgs e = new DataEntityPropertyChangedEventArgs(this, dataEntity, oldValue, newValue);
            dataEntity.OnPropertyChanged(e);
            this.removeSharedFlag(dataEntity, 0);
        }
    }

    private void removeSharedFlag(DynamicObject object, int level) {
        Object parent;
        if (object == null || level > 5) {
            return;
        }
        if (object.isShared()) {
            object.setShared(false);
            this.logChangeStack(object);
        }
        if ((parent = object.getParent()) instanceof DynamicObject) {
            this.removeSharedFlag((DynamicObject)parent, ++level);
        }
    }

    private void logChangeStack(DynamicObject object) {
        Object pk = object.getPkValue();
        StringBuilder builder = new StringBuilder();
        builder.append("DataEntityLocalCache.warnning:").append("\r\n").append(String.format("rootType=%s , subType=%s , pk=%s ", object.getDataEntityType().getName(), object.getDataEntityType().getExtendName(), pk)).append("\r\n");
        try {
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            int len = stes.length > 30 ? 30 : stes.length;
            for (int startIndex = 1; startIndex < len; ++startIndex) {
                String stack = stes[startIndex].toString();
                int p = stack.lastIndexOf(40);
                if (p != -1) {
                    stack = stack.substring(0, p) + ':' + stes[startIndex].getLineNumber();
                }
                builder.append('\t').append(stack).append('\n');
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        log.info(builder.toString());
    }

    private boolean isTypeNotEquals(Class<?> newValueType, Class<?> pType) {
        if (newValueType.equals(Long.class) && pType.equals(Long.TYPE)) {
            return false;
        }
        if (newValueType.equals(Boolean.class) && pType.equals(Boolean.TYPE)) {
            return false;
        }
        if (newValueType.equals(Integer.class) && pType.equals(Integer.TYPE)) {
            return false;
        }
        if (pType == null) {
            return false;
        }
        return newValueType != pType && !pType.isAssignableFrom(newValueType);
    }

    @Override
    @KSMethod
    public void setValue(Object dataEntity, Object value) {
        DynamicObject obj = this.convertToDynamicObject(dataEntity);
        this.setDTValue(obj, value);
    }

    @Override
    @KSMethod
    public void setValueFast(Object dataEntity, Object value) {
        DynamicObject obj = this.convertToDynamicObject(dataEntity);
        this.setDTValueFast(obj, value);
    }

    private DynamicObject convertToDynamicObject(Object dataEntity) {
        if (dataEntity == null) {
            ORMArgInvalidException e = new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u7ed9\u5b57\u6bb5\u3010%1$s.%2$s\u3011\u53d6\u503c\u6216\u8d4b\u503c\u5931\u8d25\uff1a\u4f20\u5165\u7684\u7236\u5b9e\u4f53\u503c\u4e3a\u7a7a\u3002", "DynamicProperty_6", BOS_DATAENTITY, new Object[0]), this.buildFullParentName(), this.getName()));
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put(SPAN_TAG_PROPERTY, this);
            tags.put(SPAN_TAG_DATAENTITY, dataEntity);
            EntityTracer.throwException(SPAN_TYPE_DYNAMICPROPERTY, "convertToDynamicObject", null, e, tags);
            throw e;
        }
        if (!(dataEntity instanceof DynamicObject)) {
            ORMArgInvalidException e = new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u7ed9\u5b57\u6bb5\u3010%1$s.%2$s\u3011\u53d6\u503c\u6216\u8d4b\u503c\u5931\u8d25\uff1a\u4f20\u5165\u7684\u7236\u5b9e\u4f53\u503c\u3010%3$s\u3011\u4e0d\u662fDynamicObject\u7c7b\u578b\u3002", "DynamicProperty_7", BOS_DATAENTITY, new Object[0]), this.buildFullParentName(), this.getName(), dataEntity.toString()));
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put(SPAN_TAG_PROPERTY, this);
            tags.put(SPAN_TAG_DATAENTITY, dataEntity);
            EntityTracer.throwException(SPAN_TYPE_DYNAMICPROPERTY, "convertToDynamicObject", null, e, tags);
            throw e;
        }
        return (DynamicObject)dataEntity;
    }

    private String buildFullParentName() {
        ArrayList<String> parentNames = new ArrayList<String>(1);
        for (IDataEntityType parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parentNames.add(parent.getName());
        }
        if (parentNames.isEmpty()) {
            return "";
        }
        if (parentNames.size() == 1) {
            return (String)parentNames.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = parentNames.size(); i > 0; --i) {
            sb.append((String)parentNames.get(i - 1));
            if (i <= 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    protected boolean isEquals(Object obj) {
        DynamicProperty other = (DynamicProperty)obj;
        return super.isEquals(obj) && StringUtils.equals(other._name, this._name) && other._propertyType == this._propertyType && other._ordinal == this._ordinal;
    }

    protected boolean isValueEquals(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    @Override
    public int createHashCode() {
        return this._name.hashCode() ^ this.getPropertyType().hashCode() ^ this._ordinal;
    }

    @Override
    public IDataEntityType getParent() {
        return this._parent;
    }

    void setParent(IDataEntityType parent) {
        if (this.isUnmodifiable() && this._parent != parent) {
            logger.debug(this.getClass().getSimpleName() + " parent is changed. old parent :" + this._parent.getName() + " new parent:" + (parent == null ? "" : parent.getName()));
        }
        this._parent = parent;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public boolean isEmpty(Object dataEntity) {
        throw new OrmException("####", "not support!!!");
    }

    @Override
    public int getNullBit() {
        return this.nullBit;
    }

    @Override
    public void setNullBit(int nullBit) {
        this.nullBit = nullBit;
    }

    @Override
    public int getBitPos() {
        return this.bitPos;
    }

    @Override
    public void setBitPos(int bitPos) {
        this.bitPos = bitPos;
    }

    protected void afterClone() {
    }

    private boolean isUnmodifiable() {
        if (!this.isFromClone()) {
            return this._parent.isUnmodifiable();
        }
        return false;
    }

    protected void checkUnmodifiable() {
        if (!this.isFromClone()) {
            this._parent.checkUnmodifiable();
        }
    }

    protected boolean isFromClone() {
        if (this._parent != null && this._parent.getProperties() != null) {
            for (IDataEntityProperty property : this._parent.getProperties()) {
                if (property != this) continue;
                return false;
            }
        }
        return true;
    }

    public Object getCustomProperty(String key) {
        return this.customProperties.get(key);
    }

    public Set<String> getCustomPropertyKeys() {
        return this.customProperties.keySet();
    }

    public void setCustomProperty(String key, Object value) {
        this.checkUnmodifiable();
        this.customProperties.put(key, value);
    }

    @Override
    public String toPlainString() {
        return SerializationUtils.toJsonString(this.buildPlainStrMap());
    }

    @Override
    public Map<String, Object> buildPlainStrMap() {
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("_name", this._name);
        data.put("_alias", this._alias);
        data.put("_displayName", String.valueOf(this.displayName));
        data.put("_propertyType", this._propertyType == null ? null : this._propertyType.getName());
        ArrayList<String> parentPaths = new ArrayList<String>(3);
        for (IDataEntityType parentEntity = this._parent; parentEntity != null; parentEntity = parentEntity.getParent()) {
            parentPaths.add(0, parentEntity.getName());
        }
        data.put("_parent", parentPaths.isEmpty() ? null : String.join((CharSequence)".", parentPaths.toArray(new String[parentPaths.size()])));
        data.put("_ordinal", this._ordinal);
        return data;
    }
}

