/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.dynamicobject;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DynamicPropertyCollection
extends DataEntityPropertyCollection
implements Serializable {
    private static final Log logger = LogFactory.getLog(DynamicPropertyCollection.class);
    private static final String DATAENTITY_CLONEUNMODIFIABLEPROP = "dataentity.cloneunmodifiableprop.enable";
    private static final long serialVersionUID = 4119995315629584161L;

    public DynamicPropertyCollection() {
    }

    public DynamicPropertyCollection(List<IDataEntityProperty> list, IDataEntityType owner) {
        super(list, owner, true);
    }

    @Override
    public boolean add(IDataEntityProperty property) {
        int oldOrdinal = property.getOrdinal();
        int newOrdinal = this.size();
        DynamicProperty prop = (DynamicProperty)property;
        if (this.getParent() != null) {
            if (this.addWithClone(prop)) {
                try {
                    prop = (DynamicProperty)property.clone();
                    logger.error(String.format("##DynamicPropertyCollection.add Warnning##, srcProp : %s ,clonedProp : %s", property.toPlainString(), prop.toPlainString()), (Throwable)new RuntimeException("##DynamicPropertyCollection.add Warnning##"));
                }
                catch (Throwable e) {
                    logger.error(String.format("DynamicPropertyCollection.add(prop) error, originProp:%s ; curOwner: %s", prop.toPlainString(), this.owner == null ? "" : this.owner.getExtendName()), e);
                }
            }
            this.getParent().checkUnmodifiable();
            prop.setParent(this.getParent());
        } else {
            this.owner = prop.getParent();
            IDataEntityType srcOwner = prop.getParent();
            if (srcOwner != null) {
                srcOwner.checkUnmodifiable();
            }
        }
        prop._ordinal = newOrdinal;
        return super.add(prop);
    }

    private boolean addWithClone(DynamicProperty prop) {
        if (!this.enableCloneWhenAddprop()) {
            return false;
        }
        int oldOrdinal = prop.getOrdinal();
        int newOrdinal = this.size();
        if (newOrdinal == oldOrdinal) {
            return false;
        }
        if (oldOrdinal == -1) {
            return false;
        }
        if (prop.getParent() == null) {
            return false;
        }
        if (this.getParent() == prop.getParent()) {
            return false;
        }
        if (prop.isFromClone()) {
            return false;
        }
        return this.isUnmodifiable(this.owner, 20) || this.isUnmodifiable(prop.getParent(), 20);
    }

    private boolean isUnmodifiable(IDataEntityType parent, int maxLv) {
        if (parent == null) {
            return false;
        }
        if (parent.isUnmodifiable()) {
            return true;
        }
        if (maxLv < 0) {
            return false;
        }
        return this.isUnmodifiable(parent.getParent(), --maxLv);
    }

    private boolean enableCloneWhenAddprop() {
        return Boolean.parseBoolean(System.getProperty(DATAENTITY_CLONEUNMODIFIABLEPROP, "true"));
    }

    @Override
    public boolean remove(Object element) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return super.remove(element);
    }

    @Override
    public IDataEntityProperty remove(int index) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return (IDataEntityProperty)super.remove(index);
    }

    @Override
    public void add(int index, IDataEntityProperty element) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends IDataEntityProperty> c) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IDataEntityProperty> c) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return super.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super IDataEntityProperty> filter) {
        if (this.getParent() != null) {
            this.getParent().checkUnmodifiable();
        }
        return super.removeIf(filter);
    }
}

