/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.privacy;

import java.util.Collections;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.IPrivacyCenterService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PrivacyCenterUtils {
    private static final Log log = LogFactory.getLog(PrivacyCenterUtils.class);
    private static IPrivacyCenterService service = null;

    public static boolean isEncryptField(IDataEntityProperty prop) {
        if (service == null) {
            return false;
        }
        return service.isEncryptField(prop);
    }

    public static boolean isDesensitizeField(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        if (service == null) {
            return false;
        }
        return service.isDesensitizeField(prop, localeId, operateType, dynamicObject);
    }

    public static boolean isDesensitizeField(IDataEntityProperty prop, String localeId, String operateType) {
        if (service == null) {
            return false;
        }
        return service.isDesensitizeField(prop, localeId, operateType);
    }

    public static Set<String> getEncryptFields(String tableName) {
        if (service == null) {
            return Collections.emptySet();
        }
        return service.getEncryptFields(tableName);
    }

    public static Object getDesenValueByRule(String desenRuleId, Object value) {
        return service == null ? value : service.getDesenValueByRule(desenRuleId, value);
    }

    public static Object getDesensitizeValue(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        if (service == null) {
            return value;
        }
        return service.getDesensitizeValue(prop, localeid, operateType, dynamicObject, value);
    }

    @Deprecated
    public static String getDesensitizeStrategy(IDataEntityProperty prop, String operateType) {
        if (service == null) {
            return "PLAINTEXT";
        }
        return service.getDesensitizeStrategy(prop, operateType);
    }

    public static String getDesensitizeStrategy(IDataEntityProperty prop, String operateType, DynamicObject dynamicObject) {
        if (service == null) {
            return "PLAINTEXT";
        }
        return service.getDesensitizeStrategy(prop, operateType, dynamicObject);
    }

    public static boolean isDesenAndNoSearch(IDataEntityProperty prop) {
        boolean isDesen = PrivacyCenterUtils.isDesensitizeField(prop, Lang.get().toString(), "FORM", null);
        if (isDesen) {
            boolean isSupportSearch = PrivacyDataCenterManager.getPermissionService().isSupportSearch();
            if (!isSupportSearch) {
                return true;
            }
            String strategy = PrivacyCenterUtils.getDesensitizeStrategy(prop, "LIST", null);
            if (StringUtils.isNotBlank(strategy)) {
                return !"CLICKVIEW".equals(strategy) && !"PLAINTEXT".equals(strategy);
            }
        }
        return false;
    }

    @Deprecated
    public static void checkDecryptPermission(IDataEntityProperty prop, String operateType, String operateTerminal) {
        PrivacyCenterUtils.checkDecryptPermission(prop, operateType, operateTerminal, null);
    }

    public static void checkDecryptPermission(IDataEntityProperty prop, String operateType, String operateTerminal, DynamicObject dynamicObject) {
        if (service == null) {
            return;
        }
        service.checkDecryptPermission(prop, operateType, operateTerminal, dynamicObject);
    }

    public static boolean isDesensitizeFieldWithoutPerm(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        if (service == null) {
            return false;
        }
        return service.isDesensitizeFieldWithoutPerm(prop, localeId, operateType, dynamicObject);
    }

    public static Object getDesensitizeValueWithoutPerm(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        if (service == null) {
            return value;
        }
        return service.getDesensitizeValueWithoutPerm(prop, localeid, operateType, dynamicObject, value);
    }

    public static IPrivacyCenterService getService() {
        return service;
    }

    static {
        try {
            service = (IPrivacyCenterService)Class.forName("kd.bos.privacy.service.PrivacyCenterService").newInstance();
        }
        catch (Throwable t) {
            log.error(t);
        }
    }
}

