/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ImageDirectory;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.resource.cache.PromptAnnotationResourceUtils;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkPublic;
import org.apache.log4j.Logger;

@SdkPublic
public final class ResManager {
    private static Logger logger = Logger.getLogger(ResManager.class);
    private static String subSystemType;
    private static String mClientPath;
    private static String mImageClientPath;
    private static ImageDirectory enuImageSource;
    private static ThreadLocal<String> userData;

    public static String getClientPath() {
        return mClientPath;
    }

    public static String getLanguage() {
        return Lang.get().getLocale().toString();
    }

    public static String getSubSystemType() {
        return userData.get();
    }

    public static void setSubSystemTpe(String value) {
        userData.set(value);
    }

    public static String getImageClientPath() {
        return mImageClientPath;
    }

    public static ImageDirectory getImageSource() {
        return enuImageSource;
    }

    public static void setImageSource(ImageDirectory value) {
        enuImageSource = value;
    }

    public static String LoadKDString(String description, String resourceID) {
        return ResManager.loadKDString(description, resourceID, ResManager.getSubSystemType(), new Object[0]);
    }

    public static String loadKDString(String description, String resourceID, SubSystemType systemType, Object ... args) {
        return ResManager.loadKDString(description, resourceID, ResManager.getSubSystemType(), args);
    }

    public static String loadKDString(String description, String resourceID, String systemType, Object ... args) {
        Lang lang = Lang.get();
        if (systemType == null) {
            return description;
        }
        return PromptWordCacheNew.getPromptWord(description, resourceID, lang, systemType, args);
    }

    public static String loadKDString(Lang lang, String description, String resourceID, String systemType, Object ... args) {
        if (systemType == null) {
            return description;
        }
        return PromptWordCacheNew.getPromptWord(description, resourceID, lang, systemType, args);
    }

    public static LocaleString getLocaleString(String description, String resourceID, String systemType) {
        LocaleString localeString = new LocaleString();
        List<Lang> enableLangList = ResManager.getEnableLangList();
        for (Lang lang : enableLangList) {
            localeString.setItem(lang.toString(), PromptWordCacheNew.getPromptWord(description, resourceID, lang, systemType, new Object[0]));
        }
        return localeString;
    }

    private static List<Lang> getEnableLangList() {
        ArrayList<Lang> enableLangList = new ArrayList<Lang>();
        try {
            if (RequestContext.get() == null || RequestContext.get().getAccountId() == null) {
                enableLangList.add(Lang.zh_CN);
                enableLangList.add(Lang.en_US);
                enableLangList.add(Lang.zh_TW);
                return enableLangList;
            }
            ObjectMapper mapper = new ObjectMapper();
            Class<?> clazz = Class.forName("kd.bos.servicehelper.inte.InteServiceHelper");
            Method method = clazz.getDeclaredMethod("getEnabledLang", new Class[0]);
            method.setAccessible(true);
            List langList = (List)method.invoke(clazz.newInstance(), new Object[0]);
            for (Object langObj : langList) {
                String jsonString = mapper.writeValueAsString(langObj);
                HashMap map = (HashMap)JSON.parseObject((String)jsonString, HashMap.class);
                enableLangList.add(Lang.from((String)map.get("number").toString()));
            }
            logger.debug((Object)("getEnableLangList Return:" + enableLangList));
        }
        catch (Exception exception) {
            enableLangList.add(Lang.zh_CN);
            enableLangList.add(Lang.en_US);
            enableLangList.add(Lang.zh_TW);
            logger.error((Object)("getEnableLangList:exception:" + exception));
        }
        return enableLangList;
    }

    @Deprecated
    public static String loadResFormat(String description, String resourceID, Object ... args) {
        return ResManager.loadResFormat(description, resourceID, subSystemType, args);
    }

    @Deprecated
    public static String loadResFormat(String description, String resourceID, SubSystemType systemType, Object ... args) {
        return ResManager.loadResFormat(description, resourceID, systemType.toString(), args);
    }

    @Deprecated
    public static String loadResFormat(String description, String resourceID, String systemType, Object ... args) {
        String sResult = ResManager.loadKDString(description, resourceID, systemType, args);
        int iCount = args.length;
        for (int i = 1; i <= iCount; ++i) {
            sResult = sResult.replace("%" + i, String.valueOf(args[i - 1]));
        }
        return sResult;
    }

    @Deprecated
    public static String LoadResFormat(String description, String resourceID, String sLanguage, SubSystemType systemType, Object ... args) {
        String sResult = PromptWordCacheNew.getPromptWord(description, resourceID, Lang.from((String)sLanguage), systemType.toString(), args);
        if (args != null) {
            int iCount = args.length;
            for (int i = 1; i <= iCount; ++i) {
                sResult = sResult.replace("%" + i, String.valueOf(args[i - 1]));
            }
        }
        return sResult;
    }

    public static String loadKDStringExt(String description, String resourceID, String systemType, Object ... args) {
        Lang lang = Lang.get();
        if (systemType == null) {
            return description;
        }
        String message = "";
        try {
            message = PromptWordCacheNew.getPromptWord(description, resourceID, lang, systemType, args);
            Class<?> clazz = Class.forName("kd.bos.form.i18n.MMPMsgUtils");
            Method method = clazz.getDeclaredMethod("getMessageInfo", String.class, String.class, String.class);
            method.setAccessible(true);
            String messageExt = (String)method.invoke(clazz.newInstance(), message, resourceID, systemType);
            return messageExt;
        }
        catch (Exception e) {
            logger.error((Object)"loadKDStringExt Error", (Throwable)e);
            return message;
        }
    }

    public static ResourceBundle getOpenApiAnnotationResourceBundle(Locale locale) {
        Lang lang = Lang.from((String)locale.toString());
        logger.info((Object)("getOpenApiAnnotationResourceBundle :" + locale));
        ResourceBundle bundle = PromptAnnotationResourceUtils.get(lang);
        return bundle;
    }

    public static LocaleString getOpenApiAnnotationLocaleString(String key) {
        LocaleString localeString = new LocaleString();
        List<Lang> enableLangList = ResManager.getEnableLangList();
        for (Lang lang : enableLangList) {
            localeString.setItem(lang.toString(), PromptAnnotationResourceUtils.get(lang).getString(key));
        }
        return localeString;
    }

    static {
        enuImageSource = ImageDirectory.Gui;
        userData = new ThreadLocal();
    }
}

