/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.bundle.KDPropertyResourceBundle;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JavaVersion;

public class PromptAnnotationResourceUtils {
    private static final Log logger = LogFactory.getLog(PromptAnnotationResourceUtils.class);
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    public static final String NOEXIST = "NO_EXIST_WORDS";
    private static final Map<String, ResourceBundle> bundleMap = new ConcurrentHashMap<String, ResourceBundle>();
    public static final String OPENAPI_ANNOTATION = "OpenApi_Annotation";

    private static ResourceBundle getResourceBundle(String bundleName, Lang lang, Map bundleMap) {
        ResourceBundle bundle = (ResourceBundle)bundleMap.computeIfAbsent(lang.toString(), k -> {
            try {
                Properties resultProperties = new Properties();
                Enumeration<URL> resources = PromptAnnotationResourceUtils.class.getClassLoader().getResources("resources/");
                while (resources.hasMoreElements()) {
                    Path resourcePath;
                    URL resourceUrl = resources.nextElement();
                    String urlPath = resourceUrl.getPath();
                    if (urlPath.contains("!/")) {
                        String[] parts = urlPath.split("!/");
                        Path jarPath = Paths.get(new URI(parts[0]));
                        String resource = parts[1];
                        FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
                        Throwable throwable = null;
                        try {
                            resourcePath = fs.getPath(resource, new String[0]);
                            PromptAnnotationResourceUtils.loadProperties(lang, resultProperties, resourcePath);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fs == null) continue;
                            if (throwable != null) {
                                try {
                                    fs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            fs.close();
                            continue;
                        }
                    }
                    resourcePath = Paths.get(resourceUrl.toURI());
                    PromptAnnotationResourceUtils.loadProperties(lang, resultProperties, resourcePath);
                }
                return new KDPropertyResourceBundle(resultProperties);
            }
            catch (Exception e) {
                logger.error("getResourceBundle", (Throwable)e);
                Properties properties = new Properties();
                return new KDPropertyResourceBundle(properties);
            }
        });
        return bundle;
    }

    private static void loadProperties(Lang lang, Properties properties, Path resourcePath) throws IOException {
        String localeStr = "_" + lang.toString();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(resourcePath, "openapi_*" + localeStr + ".properties");){
            for (Path path : stream) {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    if (JavaVersion.isJava17OrLater()) {
                        properties.load(inputStream);
                        continue;
                    }
                    InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    Throwable throwable2 = null;
                    try {
                        properties.load(reader);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    public static ResourceBundle get(Lang lang) {
        if (lang.toString().equalsIgnoreCase("zh_CN")) {
            ResourceBundle bundle = PromptAnnotationResourceUtils.getResourceBundle(OPENAPI_ANNOTATION, lang, bundleMap);
            return bundle;
        }
        Lang zhLang = Lang.from((String)"zh_CN");
        ResourceBundle zhCNBundle = PromptAnnotationResourceUtils.getResourceBundle(OPENAPI_ANNOTATION, zhLang, bundleMap);
        Set<String> keys = zhCNBundle.keySet();
        Properties properties = new Properties();
        for (String key : keys) {
            String value = PromptWordCacheNew.getPromptWord(zhCNBundle.getString(key), key, lang, OPENAPI_ANNOTATION, new Object[0]);
            properties.put(key, value);
        }
        return new KDPropertyResourceBundle(properties);
    }
}

