/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource.cache;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.cache.PromptResourceUtils;
import kd.bos.dataentity.resource.cache.PromptUtils;
import kd.bos.dataentity.resource.cache.PromptWordItemCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.util.ThreadLocals;
import org.apache.log4j.Logger;

public final class PromptWordCacheNew {
    private static Logger logger;
    private static final String PROJECT_LOADED_KEY = "__LOADED__";
    private static final ThreadLocal<Boolean> threadLoadingBarrier;
    private static final Map<String, LocalMemoryCache> accountProjectLocalCacheMap;
    private static final Map<String, Map<String, String>> accountProjectSpecialKeyMap;
    private static final Set<String> resourceBundleProjectList;
    private static final Set<String> defalutSupportLang;
    private static LocalMemoryCache defalutLangMap;
    private static int MAX_ELEMENTS_IN_MEMORY;
    private static final String PROMPT_PREFIX = "prompt-";
    private static LocalMemoryCache loadResIdAndProsCache;
    private static final Set<String> designerFile;

    private static Queriable readyQuery() {
        threadLoadingBarrier.set(Boolean.TRUE);
        if (ManagedThreadFeature.isManaged()) {
            return () -> threadLoadingBarrier.remove();
        }
        ManagedThreadFeature mt = new ManagedThreadFeature(false);
        mt.start();
        return () -> {
            mt.end();
            threadLoadingBarrier.remove();
        };
    }

    @Deprecated
    public String getPromptWord(String srcTran, String resId, String language, String projectNum) {
        if (projectNum == null) {
            return srcTran;
        }
        return PromptWordCacheNew.getPromptWord(srcTran, resId, Lang.from((String)language), projectNum, new Object[0]);
    }

    private static String loginPromptWord(String srcTran, String resId, Lang lang, String projectNum, Object ... args) {
        if (defalutSupportLang.contains(lang.getLocale().toString())) {
            return Resources.get((Locale)lang.getLocale(), (String)projectNum, (String)resId, (String)srcTran, (Object[])args);
        }
        try {
            Class<?> clazz = Class.forName("kd.bos.login.lang.LangContext");
            Method method = clazz.getDeclaredMethod("getDefaultLang", new Class[0]);
            method.setAccessible(true);
            Lang defaultLang = (Lang)method.invoke(clazz.newInstance(), new Object[0]);
            if (defaultLang != null) {
                return Resources.get((Locale)defaultLang.getLocale(), (String)projectNum, (String)resId, (String)srcTran, (Object[])args);
            }
            return Resources.format((String)srcTran, (Object[])args);
        }
        catch (Exception e) {
            logger.error((Object)"PromptWordCacheNew:", (Throwable)e);
            return Resources.format((String)srcTran, (Object[])args);
        }
    }

    public static LocalMemoryCache initialLocalMemoryCache(String accountProjectKey) {
        LocalMemoryCache localMemoryCache = accountProjectLocalCacheMap.get(accountProjectKey);
        if (localMemoryCache == null) {
            localMemoryCache = accountProjectLocalCacheMap.computeIfAbsent(accountProjectKey, key -> {
                CacheConfigInfo info = new CacheConfigInfo();
                info.setTimeout(3600);
                info.setMaxItemSize(MAX_ELEMENTS_IN_MEMORY);
                return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("i18", key, info);
            });
        }
        return localMemoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPromptWord(String srcTran, String resId, Lang lang, String projectNum, Object ... args) {
        String defaultResKey;
        if (resourceBundleProjectList.contains(projectNum)) {
            return PromptWordCacheNew.loginPromptWord(srcTran, resId, lang, projectNum, args);
        }
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getUserId() == null) {
            return PromptWordCacheNew.loginPromptWord(srcTran, resId, lang, projectNum, args);
        }
        String termTran = PromptWordItemCache.getPromptWord(srcTran, resId, lang, projectNum, args);
        if (!StringUtils.isEmpty(termTran)) {
            return termTran;
        }
        String properties2Word = PromptResourceUtils.get(lang.getLocale(), projectNum, resId, srcTran, args);
        if (!properties2Word.equalsIgnoreCase("NO_EXIST_WORDS")) {
            return properties2Word;
        }
        String accountProjectKey = designerFile.contains(projectNum) ? projectNum : rc.getAccountId() + '#' + projectNum;
        LocalMemoryCache localCache = PromptWordCacheNew.initialLocalMemoryCache(accountProjectKey);
        String language = lang.name();
        String resKey = resId + '#' + language;
        String trans = (String)localCache.get(resKey);
        if (trans != null) {
            return PromptUtils.format(trans, args);
        }
        if (defalutLangMap.get(rc.getAccountId()) == null) {
            PromptWordCacheNew.loadDefaultLang();
            defaultResKey = resId + '#' + defalutLangMap.get(rc.getAccountId());
        } else {
            defaultResKey = resId + '#' + defalutLangMap.get(rc.getAccountId());
        }
        Map specialKeyMap = accountProjectSpecialKeyMap.computeIfAbsent(accountProjectKey, key -> new ConcurrentHashMap());
        if (specialKeyMap.get(PROJECT_LOADED_KEY) == null) {
            Map map = specialKeyMap;
            synchronized (map) {
                if (specialKeyMap.get(PROJECT_LOADED_KEY) == null) {
                    if (threadLoadingBarrier.get() != null) {
                        return Resources.format((String)Resources.missBundle((String)srcTran), (Object[])args);
                    }
                    Map<String, String> map2 = PromptWordCacheNew.loadByProject(projectNum);
                    for (Map.Entry<String, String> entry : map2.entrySet()) {
                        localCache.put(entry.getKey(), (Object)entry.getValue());
                        specialKeyMap.put(entry.getKey(), "1");
                    }
                    specialKeyMap.put(PROJECT_LOADED_KEY, "");
                    loadResIdAndProsCache.put(accountProjectKey, (Object)"true");
                }
                trans = (String)localCache.get(resKey);
                String defaultTrans = (String)localCache.get(defaultResKey);
                if (trans == null) {
                    if (defaultTrans != null) {
                        return PromptUtils.format(defaultTrans, args);
                    }
                    return PromptUtils.format(Resources.missBundle((String)srcTran), args);
                }
                return PromptUtils.format(trans, args);
            }
        }
        if (!specialKeyMap.containsKey(resKey) && !specialKeyMap.containsKey(defaultResKey) && loadResIdAndProsCache.get(accountProjectKey) != null) {
            return srcTran == null ? Resources.missBundleKey((String)resId) : Resources.format((String)Resources.missBundle((String)srcTran), (Object[])args);
        }
        String defaultTrans = (String)localCache.get(defaultResKey);
        if (defaultTrans != null) {
            return PromptUtils.format(defaultTrans, args);
        }
        Map map = specialKeyMap;
        synchronized (map) {
            if (threadLoadingBarrier.get() != null) {
                return PromptUtils.format(Resources.missBundle((String)srcTran), args);
            }
            trans = (String)localCache.get(resKey);
            if (trans != null) {
                return PromptUtils.format(trans, args);
            }
            Map<String, String> map3 = PromptWordCacheNew.loadByProject(projectNum);
            for (Map.Entry<String, String> entry : map3.entrySet()) {
                localCache.put(entry.getKey(), (Object)entry.getValue());
                specialKeyMap.put(entry.getKey(), "1");
            }
            loadResIdAndProsCache.put(accountProjectKey, (Object)"true");
        }
        trans = (String)localCache.get(resKey);
        if (trans != null) {
            return PromptUtils.format(trans, args);
        }
        defaultTrans = (String)localCache.get(defaultResKey);
        if (defaultTrans != null) {
            return PromptUtils.format(defaultTrans, args);
        }
        return PromptUtils.format(Resources.missBundle((String)srcTran), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultLang() {
        RequestContext context = RequestContext.get();
        LocalMemoryCache localMemoryCache = defalutLangMap;
        synchronized (localMemoryCache) {
            try {
                if (defalutLangMap.get(context.getAccountId()) != null) {
                    return;
                }
                ObjectMapper mapper = new ObjectMapper();
                Class<?> clazz = Class.forName("kd.bos.servicehelper.inte.InteServiceHelper");
                Method method = clazz.getDeclaredMethod("getEnabledLang", new Class[0]);
                method.setAccessible(true);
                List langList = (List)method.invoke(clazz.newInstance(), new Object[0]);
                for (Object langObj : langList) {
                    String jsonString = mapper.writeValueAsString(langObj);
                    HashMap map = (HashMap)JSON.parseObject((String)jsonString, HashMap.class);
                    if (!map.get("isDefault").toString().equalsIgnoreCase("true")) continue;
                    logger.info((Object)("defaultLangException IsDefault:" + map.get("number")));
                    defalutLangMap.put(context.getAccountId(), (Object)map.get("number").toString());
                    return;
                }
                logger.info((Object)("defaultLangException Return:" + Lang.zh_CN.name()));
                defalutLangMap.put(context.getAccountId(), (Object)Lang.zh_CN.name());
            }
            catch (Exception exception) {
                logger.error((Object)"defaultLangException:", (Throwable)exception);
                defalutLangMap.put(context.getAccountId(), (Object)Lang.zh_CN.name());
            }
        }
    }

    private static Map<String, String> loadByProjectOpenApi(String projectNumber) {
        if (threadLoadingBarrier.get() != null) {
            return Collections.emptyMap();
        }
        String sql = "SELECT fresid,flocaleid,ftranslation,fprojectnumber from T_INT_PROMPTWORDTRAN_L where fprojectnumber like 'openapi%'";
        try (Queriable q = PromptWordCacheNew.readyQuery();){
            Map map = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, null, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(512);
                while (rs.next()) {
                    String translation = rs.getString("ftranslation");
                    if (translation != null) {
                        map.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), translation);
                        continue;
                    }
                    map.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), " ");
                }
                return map;
            });
            return map;
        }
    }

    private static Map<String, String> loadByProject(String projectNumber) {
        if (threadLoadingBarrier.get() != null) {
            return Collections.emptyMap();
        }
        if (projectNumber.equalsIgnoreCase("OpenApi_Annotation")) {
            return PromptWordCacheNew.loadByProjectOpenApi("OpenApi_Annotation");
        }
        String promptProjectNumber = PROMPT_PREFIX + projectNumber;
        String sql = "SELECT fresid,flocaleid,ftranslation,fprojectnumber from T_INT_PROMPTWORDTRAN_L where fprojectnumber in( ? , ? )";
        try (Queriable q = PromptWordCacheNew.readyQuery();){
            Map map = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{projectNumber, promptProjectNumber}, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(512);
                HashMap<String, String> promptMap = new HashMap<String, String>(512);
                while (rs.next()) {
                    String translation = rs.getString("ftranslation");
                    if (rs.getString("fprojectnumber").startsWith(PROMPT_PREFIX)) {
                        if (translation != null) {
                            promptMap.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), translation);
                            continue;
                        }
                        promptMap.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), " ");
                        continue;
                    }
                    if (translation != null) {
                        map.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), translation);
                        continue;
                    }
                    map.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), " ");
                }
                if (promptMap.size() > 0) {
                    promptMap.forEach((k, v) -> map.put((String)k, (String)v));
                }
                return map;
            });
            return map;
        }
    }

    private static String getByResourceId(String projectNumber, String resId, String localeId) {
        if (threadLoadingBarrier.get() != null) {
            return null;
        }
        String sql = "SELECT ftranslation from T_INT_PROMPTWORDTRAN_L where fprojectnumber = ? and fresid = ? and flocaleid = ?";
        try (Queriable q = PromptWordCacheNew.readyQuery();){
            String string = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{projectNumber, resId, localeId}, rs -> {
                if (rs.next()) {
                    return rs.getString("ftranslation");
                }
                return null;
            });
            return string;
        }
    }

    public void removeProjectKey(Set<String> projectNums) {
        if (projectNums == null || projectNums.isEmpty()) {
            return;
        }
        RequestContext context = RequestContext.get();
        if (context == null) {
            return;
        }
        PromptWordItemCache.removeProjectKey(projectNums);
        String accountId = context.getAccountId();
        projectNums.forEach(num -> {
            if (designerFile.contains(num)) {
                accountProjectSpecialKeyMap.remove(num);
                accountProjectLocalCacheMap.remove(num);
                loadResIdAndProsCache.remove(new String[]{num});
            } else {
                accountProjectSpecialKeyMap.remove(accountId + '#' + num);
                accountProjectLocalCacheMap.remove(accountId + '#' + num);
                loadResIdAndProsCache.remove(new String[]{accountId + '#' + num});
            }
        });
    }

    public static void removeAccountDefaultLang() {
        RequestContext context = RequestContext.get();
        if (context == null) {
            return;
        }
        defalutLangMap.remove(new String[]{context.getAccountId()});
    }

    public boolean removeAll() {
        if (!accountProjectLocalCacheMap.isEmpty()) {
            for (LocalMemoryCache cache : accountProjectLocalCacheMap.values()) {
                if (cache == null) continue;
                cache.clear();
            }
        }
        loadResIdAndProsCache.clear();
        return true;
    }

    static {
        CacheConfigInfo info;
        logger = Logger.getLogger(PromptWordCacheNew.class);
        threadLoadingBarrier = ThreadLocals.create();
        accountProjectLocalCacheMap = new ConcurrentHashMap<String, LocalMemoryCache>();
        accountProjectSpecialKeyMap = new ConcurrentHashMap<String, Map<String, String>>();
        resourceBundleProjectList = new HashSet<String>();
        defalutSupportLang = new HashSet<String>();
        defalutLangMap = null;
        MAX_ELEMENTS_IN_MEMORY = 200000;
        loadResIdAndProsCache = null;
        designerFile = new HashSet<String>();
        resourceBundleProjectList.add("bos-login");
        resourceBundleProjectList.add("bos-apm");
        resourceBundleProjectList.add("bos-archive");
        resourceBundleProjectList.add("bos-audit-exception-report");
        resourceBundleProjectList.add("bos-dataentity");
        resourceBundleProjectList.add("bos-dbengine");
        resourceBundleProjectList.add("bos-dispatcher");
        resourceBundleProjectList.add("bos-dlock");
        resourceBundleProjectList.add("bos-dts");
        resourceBundleProjectList.add("bos-dts-log");
        resourceBundleProjectList.add("bos-exception");
        resourceBundleProjectList.add("bos-eye");
        resourceBundleProjectList.add("bos-eye-api-enterprise");
        resourceBundleProjectList.add("bos-fake");
        resourceBundleProjectList.add("bos-fileservice-sdk");
        resourceBundleProjectList.add("bos-formula");
        resourceBundleProjectList.add("bos-framework");
        resourceBundleProjectList.add("bos-fulltext");
        resourceBundleProjectList.add("bos-ha");
        resourceBundleProjectList.add("bos-healthmanage");
        resourceBundleProjectList.add("bos-id");
        resourceBundleProjectList.add("bos-kdtx-common");
        resourceBundleProjectList.add("bos-kdtx-sdk");
        resourceBundleProjectList.add("bos-kdtx-server");
        resourceBundleProjectList.add("bos-ksql");
        resourceBundleProjectList.add("bos-lockme");
        resourceBundleProjectList.add("bos-logormengine");
        resourceBundleProjectList.add("bos-monitor");
        resourceBundleProjectList.add("bos-mq");
        resourceBundleProjectList.add("bos-mservice");
        resourceBundleProjectList.add("bos-mservice-auth");
        resourceBundleProjectList.add("bos-mservice-dubbox");
        resourceBundleProjectList.add("bos-mservice-hystrix");
        resourceBundleProjectList.add("bos-mservice-sdk-common");
        resourceBundleProjectList.add("bos-mservice-sentinel");
        resourceBundleProjectList.add("bos-service-core");
        resourceBundleProjectList.add("bos-ormengine");
        resourceBundleProjectList.add("bos-serverscript");
        resourceBundleProjectList.add("bos-xdb");
        resourceBundleProjectList.add("bos-xdb-manager");
        resourceBundleProjectList.add("mservice-serverscript");
        resourceBundleProjectList.add("appid");
        defalutSupportLang.add("zh_CN");
        defalutSupportLang.add("zh_TW");
        defalutSupportLang.add("en_US");
        defalutSupportLang.add("vi_VN");
        if (defalutLangMap == null) {
            info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxItemSize(300);
            defalutLangMap = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("defaultLang", "defaultLang", info);
        }
        if (loadResIdAndProsCache == null) {
            info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxItemSize(10000);
            loadResIdAndProsCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("i18npromptkey", "i18npromptkey", info);
        }
        designerFile.add("BalanceModel");
        designerFile.add("EarlyWarnModel");
        designerFile.add("BalanceUpdateModel");
        designerFile.add("BillFormModel");
        designerFile.add("WarnScheduleModel");
        designerFile.add("ReportQueryListModel");
        designerFile.add("DynamicFormModel");
        designerFile.add("LogBillFormModel");
        designerFile.add("AppModel");
        designerFile.add("MobUserGuideFormModel");
        designerFile.add("PermissomModel");
        designerFile.add("MobileFormModel");
        designerFile.add("UserGuideFormModel");
        designerFile.add("MobileListModel");
        designerFile.add("WriteBackRuleModel");
        designerFile.add("ParamterModel");
        designerFile.add("BillListCardViewModel");
        designerFile.add("CardModel");
        designerFile.add("CarEntryMenuModel");
        designerFile.add("ConvertRuleModel");
        designerFile.add("QueryListModel");
        designerFile.add("PrintModel");
        designerFile.add("MobileBillFormModel");
        designerFile.add("WidgetFormModel");
        designerFile.add("ReportFormModel");
        designerFile.add("ValidationType");
        designerFile.add("OpBizRuleType");
        designerFile.add("AbstractWorkflowModel");
        designerFile.add("BizFlowModel");
        designerFile.add("WorkflowModel");
    }

    private static interface Queriable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

