/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.cache.PromptUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.util.DisCardUtil;
import kd.bos.util.ThreadLocals;
import org.apache.log4j.Logger;

public final class PromptWordItemCache {
    private static Logger logger;
    private static final String PROJECT_LOADED_KEY = "__LOADED__";
    private static final ThreadLocal<Boolean> threadLoadingBarrier;
    private static final Map<String, LocalMemoryCache> accountProjectLocalCacheMap;
    private static final Map<String, Map<String, String>> accountProjectSpecialKeyMap;
    private static final Map<String, HashSet<String>> accountAndProMap;
    private static int MAX_ELEMENTS_IN_MEMORY;
    private static LocalMemoryCache accountIdTermProject;
    private static LocalMemoryCache loadResIdAndProsCache;
    private static final Map<String, ReentrantLock> accountIdMap;

    private static Queriable readyQuery() {
        threadLoadingBarrier.set(Boolean.TRUE);
        if (ManagedThreadFeature.isManaged()) {
            return () -> threadLoadingBarrier.remove();
        }
        ManagedThreadFeature mt = new ManagedThreadFeature(false);
        mt.start();
        return () -> {
            mt.end();
            threadLoadingBarrier.remove();
        };
    }

    public static LocalMemoryCache initialLocalMemoryCache(String accountProjectKey) {
        LocalMemoryCache localMemoryCache = accountProjectLocalCacheMap.get(accountProjectKey);
        if (localMemoryCache == null) {
            localMemoryCache = accountProjectLocalCacheMap.computeIfAbsent(accountProjectKey, key -> {
                CacheConfigInfo info = new CacheConfigInfo();
                info.setTimeout(3600);
                info.setMaxItemSize(10000);
                return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("i18term", key, info);
            });
        }
        return localMemoryCache;
    }

    private static ReentrantLock initialAccountLock(RequestContext rc) {
        ReentrantLock lock = accountIdMap.get(rc.getAccountId());
        if (lock == null) {
            lock = accountIdMap.computeIfAbsent(rc.getAccountId(), key -> new ReentrantLock());
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPromptWord(String srcTran, String resId, Lang lang, String projectNum, Object ... args) {
        Map map;
        RequestContext rc = RequestContext.get();
        List prjNums = (List)accountIdTermProject.get(rc.getAccountId());
        ReentrantLock accountIdLock = PromptWordItemCache.initialAccountLock(rc);
        if (prjNums == null) {
            if (accountIdLock.isLocked()) {
                return "";
            }
            if (accountIdLock.tryLock()) {
                try {
                    if (accountIdTermProject.get(rc.getAccountId()) == null) {
                        prjNums = PromptWordItemCache.getProjectNumber();
                        accountIdTermProject.put(rc.getAccountId(), (Object)prjNums);
                        PromptWordItemCache.clearAccountProjectSpecialKeyMap(rc.getAccountId());
                    }
                    prjNums = (List)accountIdTermProject.get(rc.getAccountId());
                }
                finally {
                    accountIdLock.unlock();
                }
            } else {
                return "";
            }
        }
        if (prjNums != null && !prjNums.contains(projectNum.trim())) {
            return "";
        }
        String accountProjectKey = rc.getAccountId() + '#' + projectNum;
        LocalMemoryCache localCache = PromptWordItemCache.initialLocalMemoryCache(accountProjectKey);
        String language = lang.name();
        String resKey = resId + '#' + language;
        String resKeyPro = resId + '#' + language + '#' + accountProjectKey;
        String trans = (String)localCache.get(resKey);
        if (trans != null) {
            return PromptUtils.format(trans, args);
        }
        Map specialKeyMap = accountProjectSpecialKeyMap.computeIfAbsent(accountProjectKey, key -> new ConcurrentHashMap());
        if (specialKeyMap.get(PROJECT_LOADED_KEY) == null) {
            map = specialKeyMap;
            synchronized (map) {
                if (specialKeyMap.get(PROJECT_LOADED_KEY) == null) {
                    if (threadLoadingBarrier.get() != null) {
                        return "";
                    }
                    Map<String, String> map2 = PromptWordItemCache.loadByProject(projectNum);
                    for (Map.Entry<String, String> entry : map2.entrySet()) {
                        localCache.put(entry.getKey(), (Object)entry.getValue());
                        PromptWordItemCache.putAccountAndProMap(accountProjectKey, entry.getKey());
                    }
                    loadResIdAndProsCache.put(accountProjectKey, (Object)"true");
                    specialKeyMap.put(PROJECT_LOADED_KEY, "");
                    trans = (String)localCache.get(resKey);
                    if (trans == null) {
                        specialKeyMap.put(resKey, "");
                        return "";
                    }
                    return PromptUtils.format(trans, args);
                }
            }
        }
        if (!PromptWordItemCache.getResources(accountProjectKey).contains(resKey) && loadResIdAndProsCache.get(accountProjectKey) != null) {
            return "";
        }
        map = specialKeyMap;
        synchronized (map) {
            if (threadLoadingBarrier.get() != null) {
                return "";
            }
            trans = (String)localCache.get(resKey);
            if (trans == null) {
                loadResIdAndProsCache.put(accountProjectKey, (Object)"true");
                PromptWordItemCache.clearAccountAndProMap(accountProjectKey);
                Map<String, String> map3 = PromptWordItemCache.loadByProject(projectNum);
                for (Map.Entry<String, String> entry : map3.entrySet()) {
                    localCache.put(entry.getKey(), (Object)entry.getValue());
                    PromptWordItemCache.putAccountAndProMap(accountProjectKey, entry.getKey());
                }
                trans = (String)localCache.get(resKey);
            }
        }
        if (trans != null) {
            return PromptUtils.format(trans, args);
        }
        specialKeyMap.put(resKey, "");
        return "";
    }

    private static void clearAccountProjectSpecialKeyMap(String accountId) {
        Set<String> keys = accountProjectSpecialKeyMap.keySet();
        for (String key : keys) {
            if (!key.contains(accountId)) continue;
            accountProjectSpecialKeyMap.remove(key);
        }
        Set<String> keyPros = accountProjectLocalCacheMap.keySet();
        for (String key : keyPros) {
            if (!key.contains(accountId)) continue;
            accountProjectLocalCacheMap.remove(key);
        }
        for (String accountAndPro : accountAndProMap.keySet()) {
            if (!accountAndPro.contains(accountId)) continue;
            PromptWordItemCache.clearAccountAndProMap(accountAndPro);
        }
    }

    private static Map<String, String> loadByProject(String projectNumber) {
        if (threadLoadingBarrier.get() != null) {
            return Collections.emptyMap();
        }
        String sql = "SELECT fresid,flocaleid,ftranslation from T_INT_PROMPTWORDTRAN_TERM where fprojectnumber = ?";
        try (Queriable q = PromptWordItemCache.readyQuery();){
            Map map = (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{projectNumber}, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(256);
                while (rs.next()) {
                    map.put(rs.getString("fresid") + '#' + rs.getString("flocaleid"), rs.getString("ftranslation"));
                }
                return map;
            });
            return map;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getProjectNumber() {
        if (threadLoadingBarrier.get() != null) return Collections.emptyList();
        try (Queriable q = PromptWordItemCache.readyQuery();){
            String sql = "SELECT distinct a.fprojectnumber  fnumber FROM t_int_promptwordtran_term a left join  t_cts_termproject b on a.fprojectnumber =b.fnumber WHERE b.fenable = '1'";
            List list = (List)DB.query((DBRoute)DBRoute.base, (String)sql, rs -> {
                ArrayList<String> list = new ArrayList<String>(16);
                while (rs.next()) {
                    list.add(rs.getString("fnumber"));
                }
                return list;
            });
            return list;
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return Collections.emptyList();
    }

    public static void removeProjectKey(Set<String> projectNums) {
        if (projectNums == null || projectNums.isEmpty()) {
            return;
        }
        RequestContext context = RequestContext.get();
        if (context == null) {
            return;
        }
        String accountId = context.getAccountId();
        projectNums.forEach(num -> {
            accountProjectSpecialKeyMap.remove(accountId + '#' + num);
            PromptWordItemCache.clearAccountAndProMap(accountId + '#' + num);
            loadResIdAndProsCache.remove(new String[]{accountId + '#' + num});
            if (accountProjectLocalCacheMap.get(accountId + '#' + num) != null) {
                accountProjectLocalCacheMap.get(accountId + '#' + num).clear();
            }
        });
        accountIdTermProject.remove(new String[]{context.getAccountId()});
    }

    public static boolean removeAll() {
        if (!accountProjectLocalCacheMap.isEmpty()) {
            for (LocalMemoryCache cache : accountProjectLocalCacheMap.values()) {
                if (cache == null) continue;
                cache.clear();
            }
            accountAndProMap.clear();
        }
        return true;
    }

    private static Set getResources(String key) {
        accountAndProMap.putIfAbsent(key, new HashSet());
        return accountAndProMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizedOperation(String key, Consumer<Set> operation) {
        Set resources;
        Set set = resources = PromptWordItemCache.getResources(key);
        synchronized (set) {
            operation.accept(resources);
        }
    }

    public static void clearAccountAndProMap(String key) {
        PromptWordItemCache.synchronizedOperation(key, x -> x.clear());
    }

    public static void putAccountAndProMap(String key, String value) {
        PromptWordItemCache.synchronizedOperation(key, x -> x.add(value));
    }

    static {
        CacheConfigInfo info;
        logger = Logger.getLogger(PromptWordItemCache.class);
        threadLoadingBarrier = ThreadLocals.create();
        accountProjectLocalCacheMap = new ConcurrentHashMap<String, LocalMemoryCache>();
        accountProjectSpecialKeyMap = new ConcurrentHashMap<String, Map<String, String>>();
        accountAndProMap = new ConcurrentHashMap<String, HashSet<String>>();
        MAX_ELEMENTS_IN_MEMORY = 1000;
        accountIdTermProject = null;
        loadResIdAndProsCache = null;
        accountIdMap = new ConcurrentHashMap<String, ReentrantLock>();
        if (accountIdTermProject == null) {
            info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxItemSize(MAX_ELEMENTS_IN_MEMORY);
            accountIdTermProject = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("i18termproject", "i18termproject", info);
        }
        if (loadResIdAndProsCache == null) {
            info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxItemSize(10000);
            loadResIdAndProsCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("i18ntermkey", "i18ntermkey", info);
        }
    }

    private static interface Queriable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

