/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializerReader;
import kd.bos.dataentity.serialization.DataEntitySerializerReaderWithIndex;
import kd.bos.dataentity.serialization.DataEntitySerializerWriter;
import kd.bos.dataentity.serialization.DataEntitySerializerWriterWithIndex;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DataEntitySerializer {
    static final String STATE_PROPERTY_PKSNAPSHOT = "pksnapshots";
    static final String STATE_PROPERTY_ISFROMDB = "isfromdb";
    static final String STATE_PROPERTY_BIZCHANGED = "bizchanged";
    static final String STATE_PROPERTY_DIRTYPROPERTIES = "dirtyprops";
    static final String STATE_PROPERTY_REMOVEDITEMS = "rmitems";
    static final String STATE_PROPERTY_ENTRYINFOS = "entryinfos";
    static final String STATE_PROPERTY_INSTANCEID = "instanceid";
    static final String STATE_PROPERTY_CACHESTATE = "cachestate";

    public static Map<String, Object> convertDataEntityToMap(Object dataEntity) {
        DataEntitySerializerWriter write = new DataEntitySerializerWriter();
        return write.serializerToMap(dataEntity);
    }

    public static Map<String, Object> convertDataEntityToMap(Object dataEntity, DataEntitySerializerOption option) {
        if (option == null) {
            option = new DataEntitySerializerOption();
        }
        DataEntitySerializerWriter writer = option.createWriter();
        return writer.serializerToMap(dataEntity);
    }

    public static String serializerToString(Object dataEntity) {
        DataEntitySerializerWriter write = new DataEntitySerializerWriter();
        return SerializationUtils.toJsonString(write.serializerToMap(dataEntity));
    }

    public static String serializerToString(Object dataEntity, boolean includeType, boolean includeComplexProperty) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeType(includeType);
        option.setIncludeComplexProperty(includeComplexProperty);
        DataEntitySerializerWriter write = new DataEntitySerializerWriter(option);
        return SerializationUtils.toJsonString(write.serializerToMap(dataEntity));
    }

    public static String serializerToString(Object dataEntity, DataEntitySerializerOption option) {
        if (option == null) {
            option = new DataEntitySerializerOption();
        }
        DataEntitySerializerWriter writer = option.createWriter();
        return SerializationUtils.toJsonString(writer.serializerToMap(dataEntity));
    }

    public static Map<String, Object> serializerToMap(IDataEntityType dt, List<DynamicObject> cols, DataEntitySerializerOption option) {
        if (option == null) {
            option = new DataEntitySerializerOption();
        }
        DataEntitySerializerWriter write = option.createWriter();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("data", write.writeCollectionProperty(cols, dt));
        if (option.isIncludeIndex()) {
            Object[] indexes = ((DataEntitySerializerWriterWithIndex)write).writeIndex(dt);
            map.put("index", indexes);
        }
        return map;
    }

    public static List<DynamicObject> deserializerFromMap(Map<String, Object> map, List<DynamicObject> cols, IDataEntityType dt, DataEntityDeserializerOption option) {
        DataEntitySerializerReaderWithIndex reader = new DataEntitySerializerReaderWithIndex(option);
        reader.indexes = (List)map.get("index");
        List data = (List)map.get("data");
        if (data == null) {
            return cols;
        }
        return reader.readCollection(cols, data, dt);
    }

    public static String[] serializerToListString(IDataEntityType dt, List<DynamicObject> cols, DataEntitySerializerOption option) {
        DataEntitySerializerWriter write = new DataEntitySerializerWriter(option);
        Object[] vals = write.writeCollectionProperty(cols, dt);
        String[] ret = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            ret[i] = SerializationUtils.toJsonString(vals[i]);
        }
        return ret;
    }

    public static List<DynamicObject> deserializerFromListString(List<DynamicObject> cols, IDataEntityType dt, String[] strList) {
        return DataEntitySerializer.deserializerFromListString(cols, dt, strList, null);
    }

    public static List<DynamicObject> deserializerFromListString(List<DynamicObject> cols, IDataEntityType dt, String[] strList, DataEntityDeserializerOption option) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(strList.length);
        for (String string : strList) {
            list.add(SerializationUtils.fromJsonStringToList(string, Object.class));
        }
        DataEntitySerializerReader reader = new DataEntitySerializerReader(option);
        return reader.readCollection(cols, list, dt);
    }

    public static DynamicObject deserializerFromListString(IDataEntityType dt, String strList) {
        return DataEntitySerializer.deserializerFromListString(dt, strList, null);
    }

    public static DynamicObject deserializerFromListString(IDataEntityType dt, String strList, DataEntityDeserializerOption option) {
        List<Object> values = SerializationUtils.fromJsonStringToList(strList, Object.class);
        DataEntitySerializerReader reader = new DataEntitySerializerReader(option);
        return (DynamicObject)reader.readObject(dt, values);
    }

    public static Object convertMapToDataEntity(IDataEntityType dt, Map<String, Object> mapObj) {
        return DataEntitySerializer.convertMapToDataEntity(dt, mapObj, null);
    }

    public static Object convertMapToDataEntity(IDataEntityType dt, Map<String, Object> mapObj, DataEntityDeserializerOption option) {
        DataEntitySerializerReader reader = mapObj.containsKey("index") ? new DataEntitySerializerReaderWithIndex(option) : new DataEntitySerializerReader(option);
        return reader.readObject(dt, mapObj);
    }

    public static Object deSerializerFromString(String strOrder, IDataEntityType dataEntityType) {
        return DataEntitySerializer.convertMapToDataEntity(dataEntityType, (Map<String, Object>)JSON.parseObject((String)strOrder), null);
    }

    public static Object deSerializerFromString(String strOrder, IDataEntityType dataEntityType, DataEntityDeserializerOption option) {
        return DataEntitySerializer.convertMapToDataEntity(dataEntityType, (Map<String, Object>)JSON.parseObject((String)strOrder), option);
    }
}

