/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;

class DataEntitySerializerWriter {
    private Map<String, Map<Object, Object[]>> refComplexPropertys = new HashMap<String, Map<Object, Object[]>>();
    private DataEntitySerializerOption serOption;
    private IDataEntityBinder dataEntityBinder;

    public DataEntitySerializerWriter() {
        this(null);
    }

    public DataEntitySerializerWriter(DataEntitySerializerOption option) {
        this.serOption = option == null ? new DataEntitySerializerOption() : option;
        this.dataEntityBinder = this.serOption.getDataEntityBinder();
    }

    public Map<String, Object> serializerToMap(Object dataEntity) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        IDataEntityType dt = dataEntity instanceof DynamicObject ? ((DynamicObject)dataEntity).getDataEntityType() : OrmUtils.getDataEntityType(dataEntity.getClass());
        if (this.serOption.isIncludeType()) {
            objMap.put("dt", this.writeObjectType(dt));
        }
        objMap.put("data", this.writeObject(dataEntity, dt));
        if (this.serOption.isIncludeComplexProperty()) {
            objMap.put("ref", this.refComplexPropertys);
        }
        if (this.serOption.isIncludeDataEntityState()) {
            objMap.put("state", true);
        }
        return objMap;
    }

    private Map<String, Object> writeObjectType(IDataEntityType dt) {
        HashMap<String, Object> dtMap = new HashMap<String, Object>();
        dtMap.put("name", dt.getName());
        dtMap.put("extname", this.getExtendName(dt));
        ArrayList props = new ArrayList();
        dtMap.put("properties", props);
        for (IDataEntityProperty p : dt.getProperties()) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("name", p.getName());
            if (!(p instanceof ISimpleProperty)) {
                if (p instanceof IComplexProperty) {
                    prop.put("type", "cmp");
                    prop.put("dt", this.writeObjectType(((IComplexProperty)p).getComplexType()));
                } else if (p instanceof ICollectionProperty) {
                    prop.put("type", "cp");
                    prop.put("dt", this.writeObjectType(((ICollectionProperty)p).getItemType()));
                }
            }
            props.add(prop);
        }
        return dtMap;
    }

    private String getExtendName(IDataEntityType dt) {
        if (dt instanceof DynamicObjectType) {
            return ((DynamicObjectType)dt).getExtendName();
        }
        return dt.getName();
    }

    private Object[] writeObject(Object dataEntity, IDataEntityType dt) {
        Map<String, Object> entityState;
        boolean bFlag = this.serOption.isIncludeDataEntityState() && dataEntity instanceof DataEntityBase;
        Object[] values = bFlag ? new Object[dt.getProperties().size() + 1] : new Object[dt.getProperties().size()];
        for (IDataEntityProperty p : dt.getProperties()) {
            if (!this.dataEntityBinder.isSerializProperty(p, this.serOption)) continue;
            Object value = p.getValueFast(dataEntity);
            if (p instanceof ILocaleProperty) {
                values[p.getOrdinal()] = value = ((ILocaleString)value).getItem("GLang");
            }
            if (p instanceof ISimpleProperty) {
                this.writeSimpleValue(values, p, value);
                continue;
            }
            if (p instanceof IComplexProperty) {
                IComplexProperty cmp = (IComplexProperty)p;
                Object id = this.writeComplexProperty(value, cmp.getComplexType());
                if (!StringUtils.isBlank(cmp.getRefIdPropName())) continue;
                values[p.getOrdinal()] = id;
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            values[p.getOrdinal()] = this.writeCollectionProperty((List)value, ((ICollectionProperty)p).getItemType());
        }
        if (bFlag && (entityState = this.writeDataEntityState(((DataEntityBase)dataEntity).getDataEntityState())) != null) {
            values[dt.getProperties().size()] = entityState;
        }
        return values;
    }

    protected void writeSimpleValue(Object[] values, IDataEntityProperty p, Object value) {
        if (value instanceof BigDecimal) {
            value = String.valueOf(value);
        } else if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        values[p.getOrdinal()] = value;
    }

    private Map<String, Object> writeDataEntityState(DataEntityState state) {
        Map<String, Boolean> cacheState;
        Map<String, EntryInfo> entryInfos;
        PkSnapshotSet pksnapshots;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean isfromdb = state.getFromDatabase();
        ret.put("isfromdb", isfromdb);
        ret.put("bizchanged", state.getBizChangeFlags());
        ret.put("dirtyprops", state.getDirtyFlags());
        ret.put("instanceid", state.getInstanceId());
        if (state.getRemovedItems().booleanValue()) {
            ret.put("rmitems", state.getRemovedItems());
        }
        if ((pksnapshots = state.getPkSnapshotSet()) != null && !pksnapshots.Snapshots.isEmpty()) {
            HashMap<String, Object[]> mapPk = new HashMap<String, Object[]>(pksnapshots.Snapshots.size());
            for (PkSnapshot pk : pksnapshots.Snapshots) {
                if (pk.Opids == null) {
                    mapPk.put(pk.TableName, new Object[]{pk.Oids});
                    continue;
                }
                mapPk.put(pk.TableName, new Object[]{pk.Oids, pk.Opids});
            }
            ret.put("pksnapshots", mapPk);
        }
        if ((entryInfos = state.getEntryInfos()) != null) {
            ret.put("entryinfos", entryInfos);
        }
        if ((cacheState = state.getCacheState()) != null) {
            ret.put("cachestate", cacheState);
        }
        return ret;
    }

    public Object[] writeCollectionProperty(List<?> objs, IDataEntityType dt) {
        Object[] collection = new Object[objs.size()];
        int index = 0;
        for (Object dataEntity : objs) {
            collection[index] = this.writeObject(dataEntity, dt);
            ++index;
        }
        return collection;
    }

    private Object writeComplexProperty(Object dataEntity, IDataEntityType dt) {
        Object id;
        if (dataEntity == null) {
            return null;
        }
        String extendName = this.getExtendName(dt);
        Map<Object, Object[]> refObj = this.refComplexPropertys.get(extendName);
        if (refObj == null) {
            refObj = new HashMap<Object, Object[]>();
            this.refComplexPropertys.put(extendName, refObj);
        }
        if (!refObj.containsKey(id = dt.getPrimaryKey().getValue(dataEntity))) {
            Object[] values = this.writeObject(dataEntity, dt);
            refObj.put(id, values);
        }
        return id;
    }
}

