/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.IBindEqualsFunc;
import kd.bos.dataentity.serialization.IBindToStringFunc;
import kd.bos.dataentity.serialization.ISetJsonValueAction;
import kd.bos.dataentity.serialization.ISetValueAction;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Element;

@SdkPublic
public abstract class DcBinder {
    public static final String ELEMENT = "Element";
    private boolean ignoreCase = false;
    private boolean onlyDbProperty = true;
    private String lcid;
    private boolean serializeDefaultValue;
    private static HashMap<String, Class<?>> primitiveTypes = new HashMap();

    public final boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public final void setIgnoreCase(boolean value) {
        this.ignoreCase = value;
    }

    public boolean isSerializeDefaultValue() {
        return this.serializeDefaultValue;
    }

    public void setSerializeDefaultValue(boolean serializeDefaultValue) {
        this.serializeDefaultValue = serializeDefaultValue;
    }

    public final boolean getOnlyDbProperty() {
        return this.onlyDbProperty;
    }

    public final void setOnlyDbProperty(boolean value) {
        this.onlyDbProperty = value;
    }

    public final String getLCId() {
        if (StringUtils.isBlank(this.lcid)) {
            this.lcid = Lang.get().toString();
        }
        return this.lcid;
    }

    public final void setLCId(String value) {
        this.lcid = value;
    }

    public IDataEntityType bindToType(String elementName, Map<String, String> attributes) {
        if (elementName != null) {
            IDataEntityType tempVar = this.tryBindToType(elementName, attributes);
            if (tempVar != null) {
                return tempVar;
            }
            Class<?> type = primitiveTypes.get(elementName);
            if (type != null) {
                return OrmUtils.getDataEntityType(type);
            }
        }
        return null;
    }

    public abstract IDataEntityType tryBindToType(String var1, Map<String, String> var2);

    public String bindToName(IDataEntityType dt) {
        return dt.getName();
    }

    public IDataEntityType getDataEntityType(Object dataEntity) {
        if (dataEntity == null) {
            return null;
        }
        IDataEntityBase entityBase = (IDataEntityBase)(dataEntity instanceof IDataEntityBase ? dataEntity : null);
        if (entityBase != null) {
            return entityBase.getDataEntityType();
        }
        return OrmUtils.getDataEntityType(dataEntity.getClass());
    }

    public Map<String, String> getDataEntityAttributes(Object dataEntity) {
        return null;
    }

    public Object createInstance(IDataEntityType dt) {
        return dt.createInstance();
    }

    public void ThrowException(SerializationException serializationException) {
        if (!serializationException.getExceptionData().getCanIgnore()) {
            throw serializationException;
        }
    }

    protected ISetValueAction bindReadAction(Class<?> dataType, ISetValueAction defaultAction) {
        return defaultAction;
    }

    public ISetJsonValueAction bindJSONReadAction(Class<?> dataType, ISetJsonValueAction defaultAction) {
        return defaultAction;
    }

    public IBindEqualsFunc bindEqualsFunc(Class<?> dataType, IBindEqualsFunc defaultFunc) {
        return defaultFunc;
    }

    public IBindToStringFunc bindToStringFunc(Class<?> dataType, IBindToStringFunc defaultFunc, RefObject<Boolean> isCData) {
        isCData.argvalue = false;
        return defaultFunc;
    }

    public static Class<?> getPrimitiveType(String elementName) {
        return elementName == null ? null : primitiveTypes.get(elementName.toLowerCase());
    }

    public void afterWriteJsonObject(Object currentEntity, Object baseEntity, Map<String, Object> serObj) {
    }

    public boolean writeSimpleProperty(Element serObj, ISimpleProperty property, Object entity) {
        return false;
    }

    public boolean readSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
        return false;
    }

    public void readCustomJsonProperty(Map.Entry<String, Object> kv, Object entity) {
    }

    public void writeCustomJsonProperties(Map<String, Object> serObj, Object current, Object base) {
    }

    public void readCustomXmlProperty(Element element, Object entity) {
    }

    public void writeCustomXmlProperties(Element serObj, Object current, Object base) {
    }

    static {
        primitiveTypes.put("boolean", Boolean.class);
        primitiveTypes.put("bool", Boolean.class);
        primitiveTypes.put("byte", Byte.class);
        primitiveTypes.put("sByte", Byte.class);
        primitiveTypes.put("int16", Short.class);
        primitiveTypes.put("iint16", Short.class);
        primitiveTypes.put("int32", Integer.class);
        primitiveTypes.put("int", Integer.class);
        primitiveTypes.put("uint32", Integer.class);
        primitiveTypes.put("int64", Long.class);
        primitiveTypes.put("uint64", Long.class);
        primitiveTypes.put("char", Character.class);
        primitiveTypes.put("double", Double.class);
        primitiveTypes.put("single", Float.class);
        primitiveTypes.put("String", String.class);
        primitiveTypes.put("decimal", BigDecimal.class);
        primitiveTypes.put("datetime", Date.class);
    }
}

