/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializerReaderImplement;
import kd.bos.dataentity.serialization.DcJsonSerializerWriteImplement;
import kd.bos.dataentity.serialization.DcSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@KSObject
public class DcJsonSerializer
extends DcSerializer {
    public static final String ExtAttributes = "_Type_";
    public static final String ElementName = "Name";
    private static final String SPAN_TYPE_DCJSONSERIALIZER = "DcJsonSerializer";

    public DcJsonSerializer(DcBinder binder) {
        super(binder);
    }

    public DcJsonSerializer(Iterable<IDataEntityType> dts) {
        super(dts);
    }

    public final String serializeToString(Object currentEntity, Object baseEntity) {
        DcJsonSerializerWriteImplement worker = new DcJsonSerializerWriteImplement(this.getBinder(), this.getSerializeComplexProperty(), this.isLocaleValueFull());
        worker._callUpdateFuncWhenCreated = this.isCallUpdateFuncWhenCreated();
        return SerializationUtils.toJsonString(worker.serialize(null, currentEntity, baseEntity));
    }

    public final Map<String, Object> serializeToMap(Object currentEntity, Object baseEntity) {
        DcJsonSerializerWriteImplement worker = new DcJsonSerializerWriteImplement(this.getBinder(), this.getSerializeComplexProperty(), this.isLocaleValueFull());
        return worker.serialize(null, currentEntity, baseEntity);
    }

    @KSMethod
    public final Object deserializeFromString(String jsonString, Object entity) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(SPAN_TYPE_DCJSONSERIALIZER, "deserializeFromString", EntityTraceHint.getHintDisLinkAPM());
            DcJsonSerializerReaderImplement worker = new DcJsonSerializerReaderImplement(this.getBinder(), this.isLocaleValueFull());
            JSONObject map = JSON.parseObject((String)jsonString);
            Object result = worker.readElement((Map<String, Object>)map, null, entity);
            worker.endInitialize();
            Object object = result;
            return object;
        }
    }

    public final Object deserializeFromMap(Map<String, Object> jsonMap, Object entity) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(SPAN_TYPE_DCJSONSERIALIZER, "deserializeFromMap", EntityTraceHint.getHintDisLinkAPM());
            DcJsonSerializerReaderImplement worker = new DcJsonSerializerReaderImplement(this.getBinder(), this.isLocaleValueFull());
            Object result = worker.readElement(jsonMap, null, entity);
            worker.endInitialize();
            Object object = result;
            return object;
        }
    }
}

