/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.DefaultSyncFunction;
import kd.bos.dataentity.ListSync;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.LocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializerWrite;
import kd.bos.dataentity.serialization.IBindEqualsFunc;
import kd.bos.dataentity.serialization.ISupplier;
import kd.bos.dataentity.utils.StringUtils;

class DcJsonSerializerWriteImplement
extends DcSerializerWrite {
    private RefObject<Boolean> tempRef_isCData = new RefObject<Boolean>(false);

    public DcJsonSerializerWriteImplement(DcBinder binder, boolean serializeComplexProperty, boolean isLocaleValueFull) {
        super(binder, serializeComplexProperty, isLocaleValueFull);
    }

    public final Map<String, Object> serialize(IDataEntityType dt, Object currentEntity, Object baseEntity) {
        return this.writeObject(dt, currentEntity, baseEntity, null);
    }

    private Map<String, Object> writeObject(IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, DcAction action) {
        if (currentEntity == null) {
            throw new IllegalArgumentException("currentEntity");
        }
        HashMap<String, Object> serObj = new HashMap<String, Object>();
        if (this.shouldCompare(currentEntityType = this.writeObjectElement(currentEntityType, currentEntity, baseEntity, action, serObj), baseEntity)) {
            if (currentEntityType.getFlag() != DataEntityTypeFlag.Primitive) {
                for (IDataEntityProperty p : currentEntityType.getProperties()) {
                    if (this._binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                    ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                    if (sp != null) {
                        this.writeSimpleProperties(serObj, sp, currentEntity, baseEntity);
                        continue;
                    }
                    IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                    if (cpx != null && this._serializeComplexProperty) {
                        this.writeComplexProperties(serObj, cpx, currentEntity, baseEntity);
                        continue;
                    }
                    ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                    if (cp == null) continue;
                    this.writeCollectionProperties(serObj, cp, currentEntityType, currentEntity, baseEntity);
                }
                this._binder.writeCustomJsonProperties(serObj, currentEntity, baseEntity);
            }
        } else if (currentEntityType.getFlag() == DataEntityTypeFlag.Primitive) {
            this.writePrimitiveObject(currentEntityType, currentEntity);
        } else {
            for (IDataEntityProperty p : currentEntityType.getProperties()) {
                if (this._binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                if (sp != null) {
                    this.writeSimpleProperties_S(serObj, sp, currentEntity);
                    continue;
                }
                IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                if (cpx != null && this._serializeComplexProperty) {
                    this.writeComplexProperties_S(serObj, cpx, currentEntity);
                    continue;
                }
                ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                if (cp == null) continue;
                this.writeCollectionProperties_S(serObj, cp, currentEntity);
            }
            this._binder.writeCustomJsonProperties(serObj, currentEntity, baseEntity);
        }
        this._binder.afterWriteJsonObject(currentEntity, baseEntity, serObj);
        return serObj;
    }

    private String writePrimitiveObject(IDataEntityType dt, Object value) {
        String str = String.valueOf(value);
        return str;
    }

    private IDataEntityType writeObjectElement(IDataEntityType dt, Object entity, Object baseEntity, DcAction action, Map<String, Object> serObj) {
        Object pkTemp;
        HashMap<String, String> arrObj = new HashMap<String, String>();
        IDataEntityType newDt = this._binder.getDataEntityType(entity);
        if (newDt != null && !newDt.equals(dt)) {
            dt = newDt;
        }
        arrObj.put("Name", this._binder.bindToName(dt));
        if (dt == null) {
            throw new ORMDesignException("??????", String.format(ResManager.loadKDString("\u5b9e\u4f53%s\u5fc5\u987b\u5b9e\u73b0IDataEntityBase\u624d\u80fd\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c\u3002", "DcJsonSerializerWriteImplement_0", SubSystemType.BOS, new Object[0]), entity.getClass().getName()));
        }
        Map<String, String> attributes = this._binder.getDataEntityAttributes(entity);
        if (attributes != null) {
            for (Map.Entry<String, String> arr : attributes.entrySet()) {
                arrObj.put(arr.getKey(), arr.getValue());
            }
        }
        ISimpleProperty pk = dt.getPrimaryKey();
        String pkValue = null;
        if (pk != null && (pkTemp = pk.getValue(entity)) != null) {
            pkValue = this.convertToString(pk, entity, pkTemp);
        }
        if (baseEntity == null && action == null) {
            action = DcAction.ListAction_Add;
        }
        if (action != null && !DcAction.ListAction_Add.equals(action)) {
            arrObj.put("action", action.getActionName());
            assert (StringUtils.isNotEmpty(pkValue));
            arrObj.put("oid", pkValue);
        }
        if (arrObj.size() > 0) {
            if (arrObj.size() == 1 && arrObj.containsKey("Name")) {
                serObj.put("_Type_", arrObj.get("Name"));
            } else {
                serObj.put("_Type_", arrObj);
            }
        }
        return dt;
    }

    private void writeSimpleProperties(Map<String, Object> serObj, ISimpleProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        IBindEqualsFunc equalsFunc = this.getEqualsFunc(property.getPropertyType());
        if (!equalsFunc.equals(currentValue, baseValue).booleanValue()) {
            if (currentValue == null) {
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("action", DcAction.PropertyAction_SetNull.getActionName());
                serObj.put(property.getName(), action);
            } else if (!this._binder.isSerializeDefaultValue() && !property.shouldSerializeValue(currentEntity)) {
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("action", DcAction.PropertyAction_Reset.getActionName());
                serObj.put(property.getName(), action);
            } else if (property.getPropertyType() == String.class || currentValue instanceof LocaleString) {
                this.tempRef_isCData.argvalue = false;
                String valueToString = this.convertToString(property, currentEntity, currentValue, this.tempRef_isCData);
                serObj.put(property.getName(), valueToString);
            } else {
                serObj.put(property.getName(), currentValue);
            }
        }
    }

    private void writeSimpleProperties_S(Map<String, Object> serObj, ISimpleProperty property, Object entity) {
        if (this._binder.isSerializeDefaultValue() || property.shouldSerializeValue(entity)) {
            Object value = property.getValue(entity);
            if (null == value) {
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("action", DcAction.PropertyAction_SetNull.getActionName());
                serObj.put(property.getName(), action);
            } else if (property.getPropertyType() == String.class || value instanceof LocaleValue) {
                if (value instanceof LocaleValue && this._isLocaleValueFull) {
                    serObj.put(property.getName(), value);
                } else if (value instanceof LocaleValue) {
                    serObj.put(property.getName(), ((LocaleValue)value).getItem(this._binder.getLCId()));
                } else {
                    String valueToString = this.convertToString(property, entity, value, this.tempRef_isCData);
                    valueToString = valueToString == null ? "" : valueToString;
                    serObj.put(property.getName(), valueToString);
                }
            } else {
                serObj.put(property.getName(), value);
            }
        }
    }

    private void writeComplexProperties(Map<String, Object> serObj, IComplexProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                serObj.put(property.getName(), DcAction.PropertyAction_SetNull.getActionName());
            }
        } else {
            Map<String, Object> value = this.writeObject(property.getComplexType(), currentValue, baseValue, null);
            if (DcJsonSerializerWriteImplement.isNeedWrite(value)) {
                serObj.put(property.getName(), value);
            }
        }
    }

    private void writeCollectionProperties(Map<String, Object> serObj, final ICollectionProperty property, final IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                serObj.put(property.getName(), DcAction.PropertyAction_SetNull.getActionName());
            }
        } else if (baseValue == null) {
            this.writeCollectionProperty(serObj, property, currentValue);
        } else {
            final ISupplier<String> getMessage = new ISupplier<String>(){

                @Override
                public String get() {
                    return String.format(ResManager.loadKDString("\u5728\u5e8f\u5217\u5316\u5bf9\u8c61%1$s\u7684\u96c6\u5408\u5c5e\u6027%2$s\u65f6\uff0c", "DcJsonSerializerWriteImplement_1", SubSystemType.BOS, new Object[0]), currentEntityType.getName(), property.getName());
                }
            };
            final List currentList = (List)(currentValue instanceof List ? currentValue : null);
            if (currentList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176(\u5f53\u524d\u5217\u8868)\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", "DcJsonSerializerWriteImplement_2", SubSystemType.BOS, new Object[0]), getMessage.get(), property.getPropertyType().getName()));
            }
            final List baseList = (List)(baseValue instanceof List ? baseValue : null);
            if (baseList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176\uff08\u57fa\u5217\u8868\uff09\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", "DcJsonSerializerWriteImplement_3", SubSystemType.BOS, new Object[0]), getMessage.get(), property.getPropertyType().getSigners()));
            }
            final ArrayList lstvalue = new ArrayList();
            DefaultSyncFunction<Object, Object> syncFunc = new DefaultSyncFunction<Object, Object>(){

                @Override
                public boolean equals(Object s, Object t) {
                    return DcJsonSerializerWriteImplement.this.listItemEquatable(currentList, baseList, s, t, getMessage);
                }

                @Override
                public void update(Object s, Object t) {
                    DcJsonSerializerWriteImplement.this.writeEditObject(lstvalue, property.getItemType(), s, t);
                }

                @Override
                public void add(List<Object> col, Object item) {
                    DcJsonSerializerWriteImplement.this.writeAddObject(lstvalue, property.getItemType(), item);
                }

                @Override
                public Object create(Object o) {
                    return o;
                }

                @Override
                public void remove(List<Object> col, Object item, int index) {
                    DcJsonSerializerWriteImplement.this.writeRemoveObject(lstvalue, item);
                }
            };
            ListSync.Sync(currentList, baseList, syncFunc, this._callUpdateFuncWhenCreated);
            if (lstvalue.size() > 0) {
                serObj.put(property.getName(), lstvalue);
            }
        }
    }

    private void writeEditObject(List<Object> jarray, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        Map<String, Object> val = this.writeObject(currentEntityType, currentEntity, baseEntity, DcAction.ListAction_Edit);
        if (DcJsonSerializerWriteImplement.isNeedWrite(val)) {
            jarray.add(val);
        }
    }

    private void writeAddObject(List<Object> jarray, IDataEntityType currentEntityType, Object currentEntity) {
        Map<String, Object> val = this.writeObject(currentEntityType, currentEntity, null, DcAction.ListAction_Add);
        jarray.add(val);
    }

    private void writeRemoveObject(List<Object> jarray, Object t) {
        IDataEntityType dt = this._binder.getDataEntityType(t);
        ISimpleProperty pk = dt.getPrimaryKey();
        HashMap obj = new HashMap();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("action", DcAction.ListAction_Remove.getActionName());
        value.put("oid", this.convertToString(pk, t, pk.getValue(t)));
        obj.put("_Type_", value);
        jarray.add(obj);
    }

    private void writeCollectionProperties_S(Map<String, Object> serObj, ICollectionProperty property, Object entity) {
        this.writeCollectionProperty(serObj, property, property.getValue(entity));
    }

    private void writeCollectionProperty(Map<String, Object> serObj, ICollectionProperty property, Object value) {
        List listValue = (List)(value instanceof List ? value : null);
        if (listValue != null && listValue.size() > 0) {
            ArrayList<Map<String, Object>> arrValue = new ArrayList<Map<String, Object>>(listValue.size());
            for (Object item : listValue) {
                arrValue.add(this.writeObject(property.getItemType(), item, null, DcAction.ListAction_Add));
            }
            serObj.put(property.getName(), arrValue);
        }
    }

    private void writeComplexProperties_S(Map<String, Object> serObj, IComplexProperty property, Object entity) {
        Map<String, Object> jvalue;
        Object value = property.getValue(entity);
        if (value != null && DcJsonSerializerWriteImplement.isNeedWrite(jvalue = this.writeObject(property.getComplexType(), value, null, null))) {
            serObj.put(property.getName(), jvalue);
        }
    }

    public static boolean isNeedWrite(Object value) {
        Object tempVar;
        Map objValue;
        return !(value instanceof Map) || !((objValue = (Map)value).size() == 1 ? (tempVar = objValue.get("_Type_")) != null : objValue.size() == 0);
    }
}

