/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.Date;
import java.util.List;
import java.util.Stack;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;

abstract class DcSerializerReader {
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    protected DcBinder _binder;
    protected Stack<ISupportInitialize> _supportInitializeObjects;
    protected boolean privateOnlyLocaleValue;
    boolean privateResetLoacaleValueBy2052;
    List<?> _lastList;
    ICollectionProperty _lastColProperty;
    Object _lastColEntity;
    protected boolean _isLocaleValueFull;

    public DcSerializerReader(DcBinder binder, boolean isLocaleValueFull) {
        if (binder == null) {
            throw new IllegalArgumentException("binder");
        }
        this._binder = binder;
        this._supportInitializeObjects = new Stack();
        this._isLocaleValueFull = isLocaleValueFull;
    }

    public boolean getOnlyLocaleValue() {
        return this.privateOnlyLocaleValue;
    }

    public void setOnlyLocaleValue(boolean value) {
        this.privateOnlyLocaleValue = value;
    }

    public boolean getResetLoacaleValueBy2052() {
        return this.privateResetLoacaleValueBy2052;
    }

    public void setResetLoacaleValueBy2052(boolean value) {
        this.privateResetLoacaleValueBy2052 = value;
    }

    protected List<?> safeGetList(ICollectionProperty property, String itemElementName, Object entity) {
        List list;
        if (this._lastColProperty == property && this._lastColEntity == entity) {
            return this._lastList;
        }
        Object temp = property.getValue(entity);
        if (temp == null) {
            if (property.getReadOnly()) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                tempVar.setCanIgnore(true);
                this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u96c6\u5408\u5c5e\u6027%s\u662f\u53ea\u8bfb\u4e14\u672a\u521d\u59cb\u5316\u503c\uff0c\u8bf7\u521d\u59cb\u5316\u7684\u503c\u6216\u63d0\u4f9bSet\u529f\u80fd\u3002", "DcSerializerReader_0", BOS_DATAENTITY, new Object[0]), property.getName()), itemElementName, tempVar, null);
            }
            try {
                temp = TypesContainer.createInstance(property.getPropertyType());
                property.setValue(entity, temp);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                tempVar2.setCanIgnore(true);
                this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u81ea\u52a8\u521b\u5efa\u96c6\u5408\u5c5e\u6027%1$s\u7684\u503c\u5931\u8d25\uff0c%2$s\u3002", "DcSerializerReader_1", BOS_DATAENTITY, new Object[0]), property.getName(), ex.getMessage()), itemElementName, tempVar2, ex);
            }
        }
        if ((list = (List)(temp instanceof List ? temp : null)) == null) {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            tempVar3.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u96c6\u5408\u5c5e\u6027%s\u5fc5\u987b\u652f\u6301IList\u63a5\u53e3", "DcSerializerReader_2", BOS_DATAENTITY, new Object[0]), property.getName()), itemElementName, tempVar3, null);
        }
        this._lastColProperty = property;
        this._lastColEntity = entity;
        this._lastList = list;
        return list;
    }

    protected void throwXmlException(String code, String message, String elementName, SerializationException.SerializationExceptionData data, RuntimeException innerException) {
        data.setElementName(elementName);
        data.setOnReading(true);
        this._binder.ThrowException(new SerializationException(code, message, data, innerException));
    }

    protected Object convertFromString(ISimpleProperty property, Object dataEntity, String str) {
        if (property.getPropertyType() == String.class) {
            return str;
        }
        if (property.getPropertyType() == Boolean.TYPE) {
            return Boolean.parseBoolean(str);
        }
        if (property.getPropertyType() == Integer.TYPE) {
            return Integer.parseInt(str);
        }
        if (property.getPropertyType() == Date.class) {
            try {
                Long v = Long.valueOf(str);
                return new Date(v);
            }
            catch (Exception e) {
                DateConverter dateConverter = new DateConverter();
                dateConverter.setPatterns(new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
                ConvertUtils.register((Converter)dateConverter, Date.class);
            }
        }
        return ConvertUtils.convert((String)str, property.getPropertyType());
    }
}

