/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.IBindEqualsFunc;
import kd.bos.dataentity.serialization.IBindToStringFunc;
import kd.bos.dataentity.serialization.ISupplier;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.beanutils.ConvertUtils;

abstract class DcSerializerWrite {
    private static final String LIST_ITEM_EQUATABLE = "ListItemEquatable";
    private Map<Class<?>, IBindEqualsFunc> _equalsFuncCache;
    DcBinder _binder;
    private Map<Class<?>, Tuple<IBindToStringFunc, Boolean>> _convertToStrFuncCache;
    protected boolean _serializeComplexProperty;
    protected boolean _isLocaleValueFull;
    protected boolean isXmlTrimText = false;
    protected boolean _callUpdateFuncWhenCreated = true;

    public DcSerializerWrite(DcBinder binder, boolean serializeComplexProperty, boolean isLocaleValueFull) {
        this._binder = binder;
        this._convertToStrFuncCache = new HashMap();
        this._serializeComplexProperty = serializeComplexProperty;
        this._isLocaleValueFull = isLocaleValueFull;
        this._equalsFuncCache = new HashMap();
    }

    protected IBindEqualsFunc getEqualsFunc(Class<?> propertyType) {
        IBindEqualsFunc result = null;
        result = this._equalsFuncCache.get(propertyType);
        if (result == null) {
            result = this.createEqualsFunc(propertyType);
            this._equalsFuncCache.put(propertyType, result);
        }
        return result;
    }

    protected IBindEqualsFunc createEqualsFunc(Class<?> propertyType) {
        IBindEqualsFunc func = ILocaleString.class.isAssignableFrom(propertyType) ? new IBindEqualsFunc(){

            @Override
            public Boolean equals(Object currentValue, Object baseValue) {
                ILocaleString currentLv = (ILocaleString)currentValue;
                ILocaleString baseLv = (ILocaleString)baseValue;
                if (currentLv == null) {
                    if (baseLv == null) {
                        return true;
                    }
                    return false;
                }
                if (baseLv == null) {
                    return false;
                }
                String lcid = DcSerializerWrite.this._binder.getLCId();
                String currentItem = (String)currentLv.getItem(lcid);
                String baseitem = (String)baseLv.getItem(lcid);
                boolean emptyCurrent = StringUtils.isBlank(currentItem);
                boolean emptyBaseItem = StringUtils.isBlank(baseitem);
                if (emptyCurrent && emptyBaseItem) {
                    return true;
                }
                if (DcSerializerWrite.this.isXmlTrimText) {
                    return StringUtils.equals(emptyCurrent ? currentItem : currentItem.trim(), emptyBaseItem ? baseitem : baseitem.trim());
                }
                return StringUtils.equals(currentItem, baseitem);
            }
        } : (byte[].class.isAssignableFrom(propertyType) ? new IBindEqualsFunc(){

            @Override
            public Boolean equals(Object currentValue, Object baseValue) {
                if (currentValue == null) {
                    if (baseValue == null) {
                        return true;
                    }
                    return false;
                }
                byte[] currentArray = (byte[])currentValue;
                byte[] baseArray = (byte[])baseValue;
                if (currentArray.length != baseArray.length) {
                    return false;
                }
                for (int i = 0; i < currentArray.length; ++i) {
                    if (currentArray[i] == baseArray[i]) continue;
                    return false;
                }
                return true;
            }
        } : new IBindEqualsFunc(){

            @Override
            public Boolean equals(Object currentValue, Object baseValue) {
                if (currentValue == baseValue) {
                    return true;
                }
                if (currentValue != null) {
                    return currentValue.equals(baseValue);
                }
                return baseValue.equals(currentValue);
            }
        });
        if ((func = this._binder.bindEqualsFunc(propertyType, func)) == null) {
            throw new IllegalArgumentException("BindEqualsFunc");
        }
        return func;
    }

    protected IBindToStringFunc getConvertFunc(Class<?> propertyType, RefObject<Boolean> isCData) {
        Tuple<IBindToStringFunc, Boolean> result = null;
        result = this._convertToStrFuncCache.get(propertyType);
        if (result == null) {
            IBindToStringFunc func = this.createConvertFunc(propertyType, isCData);
            result = new Tuple(func, isCData.argvalue);
            this._convertToStrFuncCache.put(propertyType, result);
        }
        isCData.argvalue = result.item2;
        return (IBindToStringFunc)result.item1;
    }

    IBindToStringFunc createConvertFunc(Class<?> propertyType, RefObject<Boolean> isCData) {
        IBindToStringFunc func = new IBindToStringFunc(){

            @Override
            public String apply(ISimpleProperty sp, Object dataEntity, Object value) {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof Date) {
                    return String.valueOf(((Date)value).getTime());
                }
                if (value instanceof LocaleString) {
                    return (String)((LocaleString)value).getItem(DcSerializerWrite.this._binder.getLCId());
                }
                return (String)ConvertUtils.convert((Object)value, String.class);
            }
        };
        if ((func = this._binder.bindToStringFunc(propertyType, func, isCData)) == null) {
            throw new IllegalArgumentException("BindToStringFunc");
        }
        return func;
    }

    protected String convertToString(ISimpleProperty property, Object dataEntity, Object value) {
        boolean isCData = false;
        RefObject<Boolean> tempRef_isCData = new RefObject<Boolean>(isCData);
        IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), tempRef_isCData);
        isCData = (Boolean)tempRef_isCData.argvalue;
        return func.apply(property, dataEntity, value);
    }

    protected boolean shouldCompare(IDataEntityType currentEntityType, Object baseEntity) {
        IDataEntityType baseEntityType;
        return baseEntity != null && currentEntityType.equals(baseEntityType = this._binder.getDataEntityType(baseEntity));
    }

    protected boolean listItemEquatable(List<?> sList, List<?> tList, Object s, Object t, ISupplier<String> getMessage) {
        ISimpleProperty srcPk = this._binder.getDataEntityType(s).getPrimaryKey();
        if (srcPk == null) {
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", "DcSerializerWrite_0", SubSystemType.BOS, new Object[0]), getMessage.get(), this._binder.getDataEntityType(s).getName()));
        }
        Object sPk = srcPk.getValue(s);
        if (sPk == null) {
            int index = -1;
            if (sList != null) {
                index = sList.indexOf(s);
            }
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString("%1$s\u53d1\u73b0(\u5f53\u524d\u5217\u8868)\u5176\u7b2c%2$s\u7684\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5e8f\u5217\u5316\u524d\u5fc5\u987b\u586b\u5145\u4e3b\u952e\u3002", "DcSerializerWrite_1", SubSystemType.BOS, new Object[0]), getMessage.get(), index));
        }
        ISimpleProperty targetPk = this._binder.getDataEntityType(t).getPrimaryKey();
        if (targetPk == null) {
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176\u660e\u7ec6\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", "DcSerializerWrite_0", SubSystemType.BOS, new Object[0]), getMessage.get(), this._binder.getDataEntityType(t).getName()));
        }
        Object tPk = targetPk.getValue(t);
        if (tPk == null) {
            int index = -1;
            if (tList != null) {
                index = tList.indexOf(t);
            }
            throw new OrmException(LIST_ITEM_EQUATABLE, String.format(ResManager.loadKDString("%1$s\u53d1\u73b0(\u57fa\u5217\u8868)\u5176\u7b2c%2$s\u7684\u4e3b\u952e\u4e3a\u7a7a\uff0c\u5e8f\u5217\u5316\u524d\u5fc5\u987b\u586b\u5145\u4e3b\u952e\u3002", "DcSerializerWrite_2", SubSystemType.BOS, new Object[0]), getMessage.get(), index));
        }
        return sPk.equals(tPk);
    }

    protected String convertToString(ISimpleProperty property, Object dataEntity, Object value, RefObject<Boolean> isCData) {
        IBindToStringFunc func = this.getConvertFunc(property.getPropertyType(), isCData);
        return func.apply(property, dataEntity, value);
    }
}

