/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializerReader;
import kd.bos.dataentity.serialization.IDcDescReadPlugin;
import kd.bos.dataentity.serialization.ISetValueAction;
import kd.bos.dataentity.serialization.args.EditElementArgs;
import kd.bos.dataentity.serialization.args.EditPropertyArgs;
import kd.bos.dataentity.serialization.args.RemoveElementArgs;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.dom4j.Attribute;
import org.dom4j.Element;

final class DcxmlDescRead
extends DcSerializerReader {
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String STRING = "??????";
    protected HashMap<Class<?>, ISetValueAction> _setValueActionsCache;
    private StringBuilder sbDesc;
    private IDcDescReadPlugin plugin;
    private RefObject<Object> tempRef_findItem = new RefObject();

    public DcxmlDescRead(DcBinder binder, IDcDescReadPlugin plugin) {
        super(binder, true);
        if (plugin == null) {
            throw new IllegalArgumentException("plugin");
        }
        this.sbDesc = new StringBuilder();
        this.plugin = plugin;
    }

    public Object ReadElement(Element element, IDataEntityType dt, Object entity) {
        String dtName = "?";
        String dtProperties = "not null";
        if (dt != null) {
            dtName = dt.getName();
            if (dt.getProperties() == null) {
                dtProperties = "null";
            }
        }
        if (entity == null) {
            if ((dt = this.BindToType(element, dt)) != null && dt.getFlag() != DataEntityTypeFlag.Primitive) {
                entity = this._binder.createInstance(dt);
            }
        } else {
            dt = this.GetDataEntityType(entity);
        }
        if (dt != null && StringUtils.isNotBlank(dtName) && dt.getProperties() == null && !dtName.equalsIgnoreCase(dt.getName())) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"element:" + element.asXML() + "dt.name\uff1a" + dt.getName() + " dtName:" + dtName + " dtProperties:" + dtProperties + " xml:" + element.getDocument().asXML()});
        }
        if (element.hasContent() || element.attributeCount() > 0) {
            EditElementArgs e = new EditElementArgs(this.sbDesc, element, dt, entity);
            if (this.plugin != null) {
                this.plugin.beginEditElement(e);
            }
            this.readPropertys(element, dt, entity);
            if (this.plugin != null) {
                this.plugin.endEditElement(e);
            }
        }
        return entity;
    }

    private void readPropertys(Element element, IDataEntityType dt, Object entity) {
        IDataEntityProperty property = null;
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element propElement = (Element)it.next();
            if (propElement == null) {
                throw new KDException(BosErrorCode.nullError, new Object[]{"propElement=null"});
            }
            if (dt == null || dt.getProperties() == null) {
                String msg = "";
                if (dt == null) {
                    msg = "dt==null";
                } else if (dt.getProperties() == null) {
                    String dtname = "";
                    if (StringUtils.isNotBlank(dt.getName())) {
                        dtname = dt.getName();
                    }
                    msg = " error info:  dt.name=" + dtname + ",dt.getProperties()==null";
                }
                throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString("%1$,\u8282\u70b9xml:%2$,\u5f53\u524d\u8282\u70b9text\uff1a%3$", "DcxmlDescRead_0", BOS_DATAENTITY, new Object[0]), msg, propElement.asXML(), propElement.getText())});
            }
            property = (IDataEntityProperty)dt.getProperties().get(propElement.getName());
            if (property == null || this.ReadSimpleProperty((ISimpleProperty)(property instanceof ISimpleProperty ? property : null), propElement, entity) || this.ReadComplexProperty((IComplexProperty)(property instanceof IComplexProperty ? property : null), propElement, entity) || this.ReadCollectionProperty((ICollectionProperty)(property instanceof ICollectionProperty ? property : null), propElement, entity)) continue;
            SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
            tempVar2.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString("XML\u8282\u70b9\u4e2d\u51fa\u73b0\u7684\u5c5e\u6027%s\uff0c\u5fc5\u987b\u662f\u7b80\u5355\u5c5e\u6027\u3001\u590d\u6742\u6216\u96c6\u5408\u5c5e\u6027\u7684\u4e00\u79cd\u3002", "DcxmlDescRead_2", BOS_DATAENTITY, new Object[0]), property.getName()), element.getName(), tempVar2, null);
        }
    }

    private boolean ReadSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        if (this._binder.readSimpleProperty(property, propElement, entity)) {
            return true;
        }
        String action = DcxmlDescRead.GetAttributeValue(propElement, "action", "setvalue");
        this.DoSimplePropertyAction(action, property, propElement, entity);
        return true;
    }

    private void DoSimplePropertyAction(String action, ISimpleProperty property, Element propElement, Object entity) {
        if (this.plugin == null) {
            return;
        }
        EditPropertyArgs e = new EditPropertyArgs(this.sbDesc, property, propElement, entity);
        if ("setvalue".equals(action)) {
            this.plugin.editProperty(e);
        } else if ("reset".equals(action)) {
            this.plugin.resetProperty(e);
        } else if ("setnull".equals(action)) {
            this.plugin.setNullProperty(e);
        }
    }

    private boolean ReadComplexProperty(IComplexProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        String action = DcxmlDescRead.GetAttributeValue(propElement, "action", "edit");
        this.DoComplexPropertyAction(action, property, propElement, entity);
        return true;
    }

    private void DoComplexPropertyAction(String action, IComplexProperty property, Element propElement, Object entity) {
        if (this.plugin == null) {
            return;
        }
        EditPropertyArgs e = new EditPropertyArgs(this.sbDesc, property, propElement, entity);
        if ("edit".equals(action)) {
            if (propElement.hasContent() && propElement.elements().size() > 0) {
                Object currentValue = property.getValue(entity);
                this.plugin.editProperty(e);
                this.ReadElement((Element)propElement.elements().get(0), property.getComplexType(), currentValue);
            }
        } else if ("setnull".equals(action)) {
            this.plugin.setNullProperty(e);
        }
    }

    private boolean ReadCollectionProperty(ICollectionProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        EditPropertyArgs e = new EditPropertyArgs(this.sbDesc, property, propElement, entity);
        String action = DcxmlDescRead.GetAttributeValue(propElement, "action", "add");
        if (DcAction.PropertyAction_SetNull.getActionName().equals(action)) {
            this.plugin.setNullProperty(e);
            return true;
        }
        if (DcAction.ListAction_Clear.getActionName().equals(action)) {
            this.plugin.clear(e);
            return true;
        }
        this.plugin.editProperty(e);
        Iterator it = propElement.elementIterator();
        while (it.hasNext()) {
            Element itemElement = (Element)it.next();
            action = DcxmlDescRead.GetAttributeValue(itemElement, "action", "add");
            this.DoCollectionPropertyAction(action, property, itemElement, entity);
        }
        return true;
    }

    private void DoCollectionPropertyAction(String action, ICollectionProperty property, Element itemElement, Object entity) {
        int index;
        if ("add".equals(action)) {
            EditPropertyArgs e = new EditPropertyArgs(this.sbDesc, property, itemElement, entity);
            this.plugin.add(e);
        } else if ("edit".equals(action)) {
            Object findItem = null;
            int index2 = this.FindItemByOid(property, itemElement, entity, this.tempRef_findItem);
            findItem = this.tempRef_findItem.argvalue;
            if (index2 >= 0) {
                this.ReadElement(itemElement, property.getItemType(), findItem);
            }
        } else if ("remove".equals(action) && !this.getOnlyLocaleValue() && (index = this.FindItemByOid(property, itemElement, entity, this.tempRef_findItem)) >= 0) {
            RemoveElementArgs re = new RemoveElementArgs(this.sbDesc, property, entity, this.tempRef_findItem.argvalue);
            this.plugin.remove(re);
        }
    }

    private int FindItemByOid(ICollectionProperty property, Element itemElement, Object entity, RefObject<Object> item) {
        String oid = itemElement.attributeValue("oid");
        return this.FindItemByOid(property, itemElement, entity, oid, item);
    }

    private int FindItemByOid(ICollectionProperty property, Element itemElement, Object entity, String oid, RefObject<Object> item) {
        if (StringUtils.isEmpty(oid)) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u8bd5\u56fe\u5904\u7406\u8282\u70b9%s\u6ca1\u6709\u6307\u5b9aoid", "DcxmlDescRead_3", BOS_DATAENTITY, new Object[0]), itemElement.getName()), itemElement.asXML(), tempVar, null);
            item.argvalue = null;
            return -2;
        }
        ISimpleProperty pk = property.getItemType().getPrimaryKey();
        if (pk == null) {
            SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
            tempVar2.setCanIgnore(false);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u9700\u8981\u5904\u7406\u7684\u96c6\u5408%1$s\u5176\u5143\u7d20\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", "DcxmlDescRead_4", BOS_DATAENTITY, new Object[0]), property.getName(), property.getItemType().getName()), itemElement.getName(), tempVar2, null);
            item.argvalue = null;
            return -2;
        }
        Object oid2 = this.convertFromString(pk, entity, oid);
        List<?> list = this.safeGetList(property, itemElement.getName(), entity);
        if (list == null) {
            item.argvalue = null;
            return -2;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object tempOid;
            item.argvalue = list.get(i);
            if (item.argvalue == null || !(tempOid = (pk = this._binder.getDataEntityType(item.argvalue).getPrimaryKey()).getValue(item.argvalue)).equals(oid2)) continue;
            return i;
        }
        item.argvalue = null;
        return -1;
    }

    private IDataEntityType BindToType(Element element, IDataEntityType canUseType) {
        String name = element.getName();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Object item : element.attributes()) {
            Attribute attribute = (Attribute)item;
            attributes.put(attribute.getName(), attribute.getValue());
        }
        IDataEntityType dt = this._binder.bindToType(name, attributes);
        if (dt == null && canUseType != null) {
            String canUseTypeName = this._binder.bindToName(canUseType);
            boolean isEquals = false;
            isEquals = this._binder.isIgnoreCase() ? name.equalsIgnoreCase(canUseTypeName) : name.equals(canUseTypeName);
            if (isEquals) {
                dt = canUseType;
            }
        }
        if (dt == null) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(false);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString("\u672a\u80fd\u627e\u5230%s\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u662f\u5426Xml\u4e2d\u62fc\u5199\u9519\u8bef\u3002", "DcxmlDescRead_5", BOS_DATAENTITY, new Object[0]), name), element.asXML(), tempVar, null);
        }
        return dt;
    }

    private IDataEntityType GetDataEntityType(Object entity) {
        return this._binder.getDataEntityType(entity);
    }

    private static String GetAttributeValue(Element propElement, String attName, String defaultValue) {
        assert (propElement != null);
        assert (StringUtils.isNotEmpty(attName));
        String value = propElement.attributeValue(attName);
        value = StringUtils.isEmpty(value) ? defaultValue : value.toLowerCase(Locale.ENGLISH);
        return value;
    }

    public String getDesc() {
        return this.sbDesc.toString();
    }
}

