/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.ISetJsonValueAction;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public final class DynamicObjectSerializationBinder
extends DcBinder {
    private static final Log log = LogFactory.getLog(DynamicObjectSerializationBinder.class);
    private Map<String, IDataEntityType> _dts = new HashMap<String, IDataEntityType>();

    public DynamicObjectSerializationBinder(DynamicObjectType dt) {
        this._dts.put(dt.getName(), dt);
    }

    @Override
    public IDataEntityType tryBindToType(String elementName, Map<String, String> attributes) {
        return this._dts.get(elementName);
    }

    @Override
    public ISetJsonValueAction bindJSONReadAction(Class<?> dataType, ISetJsonValueAction defaultAction) {
        ISetJsonValueAction orgin = super.bindJSONReadAction(dataType, defaultAction);
        if (dataType == ILocaleString.class) {
            return new SetILocaleValueAction(orgin);
        }
        return orgin;
    }

    static class SetILocaleValueAction
    implements ISetJsonValueAction {
        private ISetJsonValueAction defaultAction;

        public SetILocaleValueAction(ISetJsonValueAction def) {
            this.defaultAction = def;
        }

        @Override
        public void apply(ISimpleProperty sp, Object jValue, Object obj) {
            if (sp instanceof ILocaleProperty && sp.getPropertyType() == ILocaleString.class && jValue instanceof Map) {
                Object glangValue = ((Map)jValue).get("GLang");
                this.defaultAction.apply(sp, jValue, obj);
                try {
                    if (StringUtils.isNotBlank(glangValue)) {
                        ((ILocaleProperty)((Object)sp)).setGlangValue(obj, glangValue.toString());
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            } else {
                this.defaultAction.apply(sp, jValue, obj);
            }
        }
    }
}

