/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.trace.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.internal.EntityTraceInitializer;
import kd.bos.dataentity.trace.internal.EntityTraceListenerProxy;
import kd.bos.dataentity.trace.internal.EntityTraceSpanImpl;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public final class EntityTracerImpl {
    private static ThreadLocal<EntityTraceListenerProxy> lp = new ThreadLocal();
    private static ThreadLocal<Boolean> init = new ThreadLocal();
    private static String GOV_TRACE_REPORTER_TYPES = "gov.trace.reporter.types";
    private static Set<String> trace_report_types = new HashSet<String>(0);

    private EntityTracerImpl() {
    }

    public static EntityTraceSpanImpl create(String type, String name) {
        return new EntityTraceSpanImpl(type, name, EntityTracerImpl.buildHint(type, name));
    }

    public static EntityTraceSpanImpl create(String type, String name, EntityTraceHint hint) {
        return new EntityTraceSpanImpl(type, name, hint);
    }

    public static EntityTraceSpanImpl getCurrent() {
        return EntityTraceSpanImpl.getCurrent();
    }

    public static void close() {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.close();
        }
    }

    public static void addTag(String key, String value) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.addTag(key, value);
        }
    }

    public static void addLocaleTag(String key, String value) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.addLocaleTag(key, value);
        }
    }

    public static void addLocaleTag(String key, Object value) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.addLocaleTag(key, value);
        }
    }

    public static void logEvent(String event) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.logEvent(event);
        }
    }

    public static void throwException(String msg, Throwable e) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.throwException(msg, e);
        }
    }

    public static void throwException(String type, String name, String msg, Throwable e, Map<String, Object> tags) {
        try (EntityTraceSpanImpl span = new EntityTraceSpanImpl(type, name, null);){
            if (tags != null) {
                for (Map.Entry<String, Object> tag : tags.entrySet()) {
                    span.addLocaleTag(tag.getKey(), tag.getValue());
                }
            }
            span.throwException(msg, e);
        }
    }

    public static void ignoreException() {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.ignoreException();
        }
    }

    public static void error(String msg, Throwable e) {
        EntityTraceSpanImpl span = EntityTraceSpanImpl.getCurrent();
        if (span != null) {
            span.error(msg, e);
        }
    }

    public static EntityTraceListenerProxy getEntityTraceListenerProxy() {
        EntityTraceListenerProxy proxy = lp.get();
        Boolean isInit = init.get();
        if (!(isInit != null || proxy != null && proxy.isCurrentUserId())) {
            try {
                init.set(true);
                proxy = new EntityTraceListenerProxy();
                proxy.setConfig(new EntityTraceConfig());
                lp.set(proxy);
                EntityTraceInitializer entityTraceInitializer = EntityTraceInitializer.get();
                List<EntityTraceListener> listeners = entityTraceInitializer.init();
                proxy.addListener(listeners);
                proxy.setConfig(entityTraceInitializer.getConfig());
                init.set(null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return proxy;
    }

    private static EntityTraceHint buildHint(String type, String name) {
        if (trace_report_types.contains(type)) {
            return EntityTraceHint.getHintLinkAPM();
        }
        return EntityTraceHint.getHintDisLinkAPM();
    }

    private static void readTraceReporterTypes() {
        try {
            String property = System.getProperty(GOV_TRACE_REPORTER_TYPES);
            if (StringUtils.isEmpty(property)) {
                trace_report_types = new HashSet<String>(0);
            } else {
                String[] split = property.split(",");
                HashSet<String> types = new HashSet<String>(split.length);
                for (String name : split) {
                    types.add(name.trim());
                }
                trace_report_types = types;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static {
        EntityTracerImpl.readTraceReporterTypes();
        ConfigurationUtil.observeChange((String)GOV_TRACE_REPORTER_TYPES, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                EntityTracerImpl.readTraceReporterTypes();
            }
        });
    }
}

