/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.utils;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class DataCacheReader {
    private static Class<?> cacheReaderClass;
    private static Method loadFromCacheMethod;
    private static Class<?> entityMetadataCacheClass;
    private static Method getDataEntityType;
    private static Method getSubDataEntityType;
    private static Class<?> metadataDaoClass;
    private static Method getAppNumberByEntityNumber;

    public static DataCacheReader get() {
        return MessagerSenderHolder.instance;
    }

    public Map<Object, DynamicObject> loadFromCache(Object[] array, DynamicObjectType entityType, boolean b) {
        Map loadFromCache;
        if (loadFromCacheMethod != null) {
            try {
                loadFromCache = (Map)loadFromCacheMethod.invoke(cacheReaderClass, array, entityType, b);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{" loadFromCache error"});
            }
        } else {
            loadFromCache = Collections.emptyMap();
        }
        return loadFromCache;
    }

    public DynamicObjectType getSubDataEntityType(String entityNumber, Collection<String> properties) {
        DynamicObjectType dynamicObject = null;
        if (getSubDataEntityType != null) {
            try {
                dynamicObject = (DynamicObjectType)getSubDataEntityType.invoke(entityMetadataCacheClass, entityNumber, properties);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{" getSubDataEntityType error"});
            }
        }
        return dynamicObject;
    }

    public DynamicObjectType getDataEntityType(String entityNumber) {
        DynamicObjectType dynamicObject = null;
        if (getDataEntityType != null) {
            try {
                dynamicObject = (DynamicObjectType)getDataEntityType.invoke(entityMetadataCacheClass, entityNumber);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{" getDataEntityType error"});
            }
        }
        return dynamicObject;
    }

    public String getAppid(String entityNumber) {
        String appid = null;
        if (getAppNumberByEntityNumber != null) {
            try {
                appid = (String)getAppNumberByEntityNumber.invoke(metadataDaoClass, entityNumber);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{" getAppid error"});
            }
        }
        return appid;
    }

    static {
        try {
            cacheReaderClass = Class.forName("kd.bos.data.BusinessDataReader");
            loadFromCacheMethod = cacheReaderClass.getDeclaredMethod("loadFromCache", Object[].class, DynamicObjectType.class, Boolean.TYPE);
            entityMetadataCacheClass = Class.forName("kd.bos.entity.EntityMetadataCache");
            getDataEntityType = entityMetadataCacheClass.getDeclaredMethod("getDataEntityType", String.class);
            getSubDataEntityType = entityMetadataCacheClass.getDeclaredMethod("getSubDataEntityType", String.class, Collection.class);
            metadataDaoClass = Class.forName("kd.bos.metadata.dao.MetadataDao");
            getAppNumberByEntityNumber = metadataDaoClass.getDeclaredMethod("getAppNumberByEntityNumber", String.class);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{"get kd.bos.dts.DtsMsgSender method error"});
        }
    }

    private static class MessagerSenderHolder {
        private static DataCacheReader instance = new DataCacheReader();

        private MessagerSenderHolder() {
        }
    }
}

