/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.IListSyncFunction;
import kd.bos.dataentity.ListSync;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DataEntityWalkerEventArgs;
import kd.bos.dataentity.entity.DataEntityWalkerListner;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class OrmUtils {
    private static final Log logger = LogFactory.getLog(OrmUtils.class);

    public static IDataEntityType getDataEntityType(Class<?> type) {
        return DataEntityType.getDataEntityType(type);
    }

    @SdkInternal
    public static void makeUnmodifiable(DynamicObjectType dt) {
        try {
            Method method = dt.getClass().getDeclaredMethod("setUnmodifiable", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)dt, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage());
        }
    }

    public static void DataEntityWalker(Collection<? extends Object> dataEntities, IDataEntityType dt, DataEntityWalkerListner callback, boolean onlyDbProperty) {
        DataEntityWalkerEventArgs.DataEntityWalker(dataEntities, dt, callback, onlyDbProperty);
    }

    public static <SourceT, TargetT> void sync(List<SourceT> sourceList, List<TargetT> targetList, IListSyncFunction<SourceT, TargetT> syncFunction, boolean callUpdateFuncWhenCreated) {
        ListSync.Sync(sourceList, targetList, syncFunction, callUpdateFuncWhenCreated);
    }

    public static Object clone(IDataEntityBase dataEntity, boolean onlyDbProperty, boolean clearPrimaryKeyValue) {
        return new CloneUtils(onlyDbProperty, clearPrimaryKeyValue).clone(dataEntity);
    }

    public static Object clone(Object dataEntity, IDataEntityType dt, boolean onlyDbProperty, boolean clearPrimaryKeyValue) {
        if (dataEntity == null) {
            return null;
        }
        if (dt == null) {
            throw new IllegalArgumentException("dt");
        }
        return new CloneUtils(onlyDbProperty, clearPrimaryKeyValue).clone(dt, dataEntity);
    }

    public static <T> T getPrimaryKeyValue(IDataEntityBase dataEntity, boolean throwOnError) {
        if (dataEntity == null) {
            if (throwOnError) {
                throw new IllegalArgumentException("dataEntity");
            }
            return null;
        }
        ISimpleProperty pk = dataEntity.getDataEntityType().getPrimaryKey();
        if (pk == null) {
            if (throwOnError) {
                throw new OrmException("OrmUtil.GetPrimaryKeyValue", String.format(ResManager.loadKDString("\u5b9e\u4f53\u7c7b\u578b%s\u6c92\u6709\u5b9a\u4e49\u4e3b\u952e\uff0c\u65e0\u6cd5\u83b7\u53d6\u3002", "OrmUtils_0", "bos-dataentity", new Object[0]), dataEntity.getDataEntityType().getName()));
            }
            return null;
        }
        return (T)pk.getValue(dataEntity);
    }

    @SdkInternal
    public static <T> int getListHashCode(Iterable<T> list) {
        int h = 0;
        if (list == null) {
            return h;
        }
        for (T item : list) {
            h ^= item.hashCode();
        }
        return h;
    }

    public static <T> boolean getListEquals(Iterable<T> x, Iterable<T> y) {
        if (x == null || y == null) {
            return x == null && y == null;
        }
        Iterator<T> xi = x.iterator();
        Iterator<T> yi = y.iterator();
        while (xi.hasNext()) {
            if (!yi.hasNext()) {
                return false;
            }
            if (xi.next().equals(yi.next())) continue;
            return false;
        }
        return true;
    }
}

