/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.invoke;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.manage.MServiceMetaManage;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.invoke.spring.MServiceSpringBeanManager;

public class MServiceFactory {
    private static final Map<String, Object> cachedObj = new ConcurrentHashMap<String, Object>(2);
    private static final Log log = LogFactory.getLog(MServiceFactory.class);
    private static final Map<String, Method> serviceMethodMap = new ConcurrentHashMap<String, Method>();

    public static Object getService(String serviceName) {
        return cachedObj.computeIfAbsent(serviceName, k -> {
            try {
                MServiceDefineMeta serviceDef = MServiceMetaManage.getServiceDefine((String)serviceName);
                String serviceClassName = serviceDef.getServiceImplClass();
                Class<?> cls = Class.forName(serviceClassName);
                Object object = MServiceSpringBeanManager.getBean(cls);
                if (object == null) {
                    object = cls.newInstance();
                }
                return object;
            }
            catch (Exception e) {
                log.error("service not found", (Throwable)e);
                return null;
            }
        });
    }

    public static MServiceDefineMeta getServiceDefine(String serviceName) {
        return MServiceMetaManage.getServiceDefine((String)serviceName);
    }

    public static MServiceDefineMeta getServiceDefineByPath(String path) {
        return MServiceMetaManage.getServiceDefineByPath((String)path);
    }

    public static MServiceDefineMeta.MethodDefine getMethodDefineByRequestPath(String serviceName, String requestPath) {
        if (requestPath == null) {
            return null;
        }
        MServiceDefineMeta serviceDefine = MServiceMetaManage.getServiceDefine((String)serviceName);
        List methodDefines = serviceDefine.getMethods();
        for (MServiceDefineMeta.MethodDefine md : methodDefines) {
            if (!requestPath.equals(md.getServiceMethodPath())) continue;
            return md;
        }
        return null;
    }

    public static Method findServiceMethod(Class<?> clazz, String methodName, int paramterLength) {
        String key = clazz.getName() + '#' + methodName + '#' + paramterLength;
        Method retMethod = serviceMethodMap.computeIfAbsent(key, k -> {
            Method serviceMethod = null;
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(methodName) || m.getParameterCount() != paramterLength) continue;
                serviceMethod = m;
                break;
            }
            if (serviceMethod == null) {
                throw new KDException(new ErrorCode("###", "not find method %s.%s"), new Object[]{clazz.getName(), methodName});
            }
            return serviceMethod;
        });
        return retMethod;
    }
}

