/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.fullgc;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.fullgc.FullGcListener;
import kd.bos.mservice.fullgc.FullGcRegisterMetricListener;
import kd.bos.mservice.fullgc.MemoryRecycle;

public class FullGcManage
implements NotificationListener {
    private static Log log = LogFactory.getLog(FullGcManage.class);
    private static Map<String, FullGcListener> listeners = new ConcurrentHashMap<String, FullGcListener>();
    private volatile boolean isG1 = false;
    private static int fullGcOverloadCount = 0;

    public static int getFullGcOverloadCount() {
        return fullGcOverloadCount;
    }

    public static void setFullGcOverloadCount(int fullGcOverloadCount) {
        FullGcManage.fullGcOverloadCount = fullGcOverloadCount;
    }

    public void listen() throws Exception {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            String name = gcBean.getName();
            if (!name.equals("G1 Old Generation") && !name.equals("PS MarkSweep")) continue;
            this.isG1 = name.equals("G1 Old Generation");
            ObjectName objectName = gcBean.getObjectName();
            NotificationFilter filter = new NotificationFilter(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isNotificationEnabled(Notification notification) {
                    return notification.getType().equals("com.sun.management.gc.notification");
                }
            };
            ManagementFactory.getPlatformMBeanServer().addNotificationListener(objectName, this, filter, null);
        }
        log.info("Full GC listener started.");
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
        if (info.getGcAction().equals("end of major GC")) {
            StringBuilder sb = new StringBuilder();
            sb.append("\r\n").append("fullgc event occurred:");
            sb.append("\r\n").append("GC action: ").append(info.getGcAction());
            sb.append("\r\n").append("GC name: ").append(info.getGcName());
            sb.append("\r\n").append("GC cause: ").append(info.getGcCause());
            sb.append("\r\n").append("GC start time: ").append(new Date(info.getGcInfo().getStartTime()));
            sb.append("\r\n").append("GC end time: ").append(new Date(info.getGcInfo().getEndTime()));
            sb.append("\r\n").append("GC duration: ").append(info.getGcInfo().getDuration()).append(" ms");
            sb.append("\r\n").append("GC memory usage before: ").append(info.getGcInfo().getMemoryUsageBeforeGc());
            sb.append("\r\n").append("GC memory usage after: ").append(info.getGcInfo().getMemoryUsageAfterGc());
            log.warn(sb.toString());
            List<MemoryRecycle> ls = MemoryRecycle.parseRecycleInfo(info.getGcInfo());
            String keyPre = this.isG1 ? "G1 " : "PS ";
            MemoryRecycle summ = MemoryRecycle.sum(ls, keyPre);
            int overloadPercent = Integer.getInteger("fullgc.overload.recycle.percent", 90);
            int recoverpercent = Integer.getInteger("fullgc.overload.recover.percent", 60);
            long useBeforeP = summ.getUseBefore();
            long useAfter = summ.getAfter();
            long max = summ.getMax();
            if (useBeforeP * 100L > max * (long)overloadPercent && useAfter * 100L > useBeforeP * (long)overloadPercent) {
                listeners.forEach((k, v) -> {
                    try {
                        v.overloadAction(info.getGcInfo().getDuration(), summ);
                    }
                    catch (Exception e) {
                        log.error("doAction for fullgc error," + k, (Throwable)e);
                    }
                });
            } else if (useAfter * 100L < useBeforeP * (long)recoverpercent) {
                listeners.forEach((k, v) -> {
                    try {
                        v.recoverAction(info.getGcInfo().getDuration(), summ);
                    }
                    catch (Exception e) {
                        log.error("doAction for fullgc error," + k, (Throwable)e);
                    }
                });
            }
        }
    }

    static {
        FullGcRegisterMetricListener gcMetric = new FullGcRegisterMetricListener();
        listeners.put(gcMetric.name(), gcMetric);
    }
}

