/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.action.impl;

import java.util.concurrent.locks.LockSupport;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.action.AbstractAction;
import kd.bos.mservice.monitor.action.impl.ServiceUtil;
import kd.bos.mservice.monitor.report.HealthReporter;
import kd.bos.util.EnvUtils;

public class Restart
extends AbstractAction {
    private static Log logger = LogFactory.getLog(Restart.class);

    @Override
    public void execute() {
        ServiceUtil.warn("will auto restart because " + this.param.getIndicator() + " is error," + this.param.getDesc());
        LockSupport.parkNanos((long)this.param.getWaitSeconds() * 1000000000L);
        HealthReporter.getInstance().reportAction(this.getClass().getSimpleName(), this.getParam());
        if (EnvUtils.isRunningInsideContainer()) {
            LockSupport.parkNanos(1000000000L);
            System.exit(1);
        } else {
            try {
                String propCmd;
                String cmdPath = System.getProperty("user.dir");
                if (!cmdPath.startsWith("/")) {
                    cmdPath = cmdPath + "/";
                }
                cmdPath = (propCmd = System.getProperty("restartCmd")) != null ? cmdPath + propCmd : (EnvUtils.isWindows() ? cmdPath + "start.bat restart" : cmdPath + "start.sh restart");
                ServiceUtil.warn("Execute " + cmdPath + " to restart and will exit smoothly!!");
                LockSupport.parkNanos(3000000000L);
                System.exit(1);
            }
            catch (Exception e) {
                logger.error("restart error", (Throwable)e);
            }
        }
    }
}

