/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.assistant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.db.datasource.DataSourceMXBeanImpl;
import kd.bos.mservice.monitor.assistant.AssistDiagnose;
import kd.bos.mservice.monitor.assistant.ThreadStackUtils;
import kd.bos.mservice.monitor.healthmanage.indicator.DBPoolIndicator;

public class DBActionConnectionAssistDiagnose
implements AssistDiagnose<String> {
    @Override
    public String getAssistantInfo() {
        List connectionActiveThreadList = DataSourceMXBeanImpl.get().getActiveConnectionThreadsInfo();
        HashMap<String, AtomicInteger> stackCounts = new HashMap<String, AtomicInteger>(1);
        HashSet activeThreadNames = new HashSet(2);
        connectionActiveThreadList.forEach(m -> {
            String stack = (String)m.get("conActiveStack");
            if (stack != null && stack.length() > 0) {
                stackCounts.computeIfAbsent(stack, k -> new AtomicInteger(0)).incrementAndGet();
            }
            String thread = (String)m.get("conActiveThread");
            activeThreadNames.add(thread);
        });
        if (!stackCounts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("conActiveStack: \n");
            stackCounts.forEach((stack, count) -> sb.append("[count of stack trace:").append(count.get()).append("]   \t").append((String)stack).append("\n"));
            return sb.toString();
        }
        HashMap<Thread, StackTraceElement[]> threadMap = new HashMap<Thread, StackTraceElement[]>(8);
        Map<Thread, StackTraceElement[]> m2 = Thread.getAllStackTraces();
        m2.forEach((t, s) -> {
            if (activeThreadNames.contains(t.toString()) || DBPoolIndicator.isStatckElementsForDBWait(s)) {
                threadMap.put((Thread)t, (StackTraceElement[])s);
            }
        });
        return ThreadStackUtils.getFormatStack(threadMap);
    }
}

