/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.assistant;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.mservice.monitor.assistant.AssistDiagnose;

public class TopThreadAssistDiagnose
implements AssistDiagnose<String> {
    private int caiyang = 3;
    private int topN = 5;
    private int waitperiod = 500;
    private static int maxStack = 1000;
    private static String ENDTAG = ".......";

    @Override
    public String getAssistantInfo() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadids = bean.getAllThreadIds();
        HashMap<Long, LimitQueue<TInfo>> map = new HashMap<Long, LimitQueue<TInfo>>(2);
        long beginTime = System.nanoTime();
        int i = this.caiyang;
        while (i-- >= 0) {
            this.genCpuTime(bean, threadids, map);
            LockSupport.parkNanos((long)this.waitperiod * 1000000L);
        }
        long caiyangCpuTotalTime = System.nanoTime() - beginTime;
        ArrayList ls = new ArrayList(map.entrySet());
        Collections.sort(ls, new Comparator<Map.Entry<Long, LimitQueue<TInfo>>>(){

            @Override
            public int compare(Map.Entry<Long, LimitQueue<TInfo>> o1, Map.Entry<Long, LimitQueue<TInfo>> o2) {
                LimitQueue<TInfo> q1 = o1.getValue();
                LimitQueue<TInfo> q2 = o2.getValue();
                long q1cputime = q1.getLast().cpuUseTime - q1.getFirst().cpuUseTime;
                long q2cputime = q2.getLast().cpuUseTime - q2.getFirst().cpuUseTime;
                return (int)(q2cputime - q1cputime);
            }
        });
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this.topN; ++j) {
            LimitQueue queue = (LimitQueue)((Map.Entry)ls.get(j)).getValue();
            long gtotalCpuTime = ((TInfo)queue.getLast()).cpuUseTime - ((TInfo)queue.getFirst()).cpuUseTime;
            String threadName = ((TInfo)queue.getLast()).threadname;
            double cpuuse = gtotalCpuTime * 100L / caiyangCpuTotalTime;
            if (cpuuse < 2.0) continue;
            sb.append(String.format("top %s :thread[%s] usage %s", j + 1, threadName, cpuuse)).append(" ; ");
            sb.append("stack is :\r\n");
            TInfo info = (TInfo)queue.poll();
            HashMap<String, AtomicInteger> stackStatics = new HashMap<String, AtomicInteger>(8);
            AtomicInteger total = new AtomicInteger(0);
            while (info != null) {
                stackStatics.computeIfAbsent(info.stack, k -> new AtomicInteger(0)).incrementAndGet();
                info = (TInfo)queue.poll();
                total.incrementAndGet();
            }
            stackStatics.forEach((k, v) -> sb.append("[").append(v).append("/").append(total.get()).append(" times appeared]").append("\r\n").append((String)k).append("\r\n"));
            sb.append("\r\n\r\n");
        }
        return sb.toString();
    }

    private void genCpuTime(ThreadMXBean bean, long[] threadids, Map<Long, LimitQueue<TInfo>> map) {
        Map<Thread, StackTraceElement[]> threadsMap = Thread.getAllStackTraces();
        HashMap threadsIdMap = new HashMap(16);
        threadsMap.forEach((t, v) -> threadsIdMap.put(t.getId(), t));
        for (long threadid : threadids) {
            Thread thread;
            if (Thread.currentThread().getId() == threadid || (thread = (Thread)threadsIdMap.get(threadid)) == null) continue;
            LimitQueue queue = map.computeIfAbsent(threadid, k -> new LimitQueue(this.caiyang + 1));
            long cputime = bean.getThreadCpuTime(threadid);
            TInfo tinfo = new TInfo();
            tinfo.cpuUseTime = cputime;
            tinfo.threadname = thread.getName();
            tinfo.stack = this.getStack(threadsMap.get(thread), threadid);
            queue.offer(tinfo);
        }
    }

    private String getStack(StackTraceElement[] ses, long threadid) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < maxStack && i < ses.length; ++i) {
            sb.append(ses[i].toString()).append(" \r\r\r\n ");
        }
        if (ses.length >= maxStack) {
            sb.append(ENDTAG);
        }
        return sb.toString();
    }

    static class TInfo {
        long cpuUseTime;
        String threadname;
        String stack;

        TInfo() {
        }
    }
}

