/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.ServiceHealthIndicatorDef;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class ServiceHealthIndicatorConfig {
    private List<ServiceHealthIndicatorDef> items;
    private static Log log = LogFactory.getLog(ServiceHealthIndicatorConfig.class);

    @XmlElements(value={@XmlElement(name="item", type=ServiceHealthIndicatorDef.class)})
    public List<ServiceHealthIndicatorDef> getItems() {
        return this.items;
    }

    public void setItems(List<ServiceHealthIndicatorDef> items) {
        this.items = items;
    }

    public static ServiceHealthIndicatorConfig get() {
        String xml = System.getProperty("mservice.monitor.servicehealthindicator");
        if (xml == null) {
            InputStream in = ServiceHealthIndicatorConfig.class.getResourceAsStream("/mservice/monitor/servicehealthindicator.xml");
            try {
                xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
            }
            catch (IOException e) {
                log.error("Can't load servicehealthindicator.xml", (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("close getResourceAsStream error");
                }
            }
        }
        if (xml == null) {
            return null;
        }
        ServiceHealthIndicatorConfig base = ServiceHealthIndicatorConfig.parse(xml);
        return base;
    }

    private static ServiceHealthIndicatorConfig parse(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceHealthIndicatorConfig.class});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            Unmarshaller un = jaxbContext.createUnmarshaller();
            XMLStreamReader xsr = xif.createXMLStreamReader(reader);
            ServiceHealthIndicatorConfig usageConfig = (ServiceHealthIndicatorConfig)un.unmarshal(xsr);
            return usageConfig;
        }
        catch (Error | Exception t) {
            log.error(t);
            return null;
        }
    }
}

