/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterNotifyHealthFactory;
import kd.bos.mservice.monitor.healthmanage.cluster.InstanceHealthInfo;
import kd.bos.mservice.monitor.healthmanage.config.HealthConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.WorstIndicatorInfo;

public class ClusterHealth {
    private static Cache<String, Integer> cache = CacheBuilder.newBuilder().expireAfterWrite((long)(HealthConfig.getBroadcastNotifyInterval() + 2), TimeUnit.SECONDS).build();
    private static final Map<String, String> instanceHosts = new ConcurrentHashMap<String, String>(4);
    private static final Map<String, Long> instanceLastestUpdate = new ConcurrentHashMap<String, Long>(4);

    public static void updateHealth(List<InstanceHealthInfo> healthls) {
        for (InstanceHealthInfo instance : healthls) {
            ClusterHealth.setHealth(instance.getInstanceId(), instance.getInstanceUpdateTime(), instance.getLevel());
        }
    }

    public static void updateHealth(String instanceid, long timestap, WorstIndicatorInfo level) {
        ClusterHealth.setHealth(instanceid, timestap, level.getLevel());
    }

    private static void setHealth(String instaneid, long timestap, int level) {
        Long timeObj = instanceLastestUpdate.get(instaneid);
        if (timeObj == null || timestap > timeObj) {
            instanceLastestUpdate.put(instaneid, timestap);
            cache.put((Object)instaneid, (Object)level);
        }
    }

    public static int getHealth(String instanceid) {
        Integer level = (Integer)cache.getIfPresent((Object)instanceid);
        return level == null ? HealthLevel.ERROR.getLevel() : level.intValue();
    }

    public static Map<String, String> getInstancehostsMap() {
        return instanceHosts;
    }

    public static String getInstanceHost(String instanceId) {
        return instanceHosts.get(instanceId);
    }

    public static Map<String, Map<Integer, AtomicInteger>> getClusterApplicationHealth() {
        HashMap<String, Map<Integer, AtomicInteger>> rt = new HashMap<String, Map<Integer, AtomicInteger>>(2);
        cache.asMap().forEach((instanceId, level) -> {
            String appName = Instance.getAppNameFromInstanceId((String)instanceId);
            Map levelMap = rt.computeIfAbsent(appName, k -> new HashMap(1));
            levelMap.computeIfAbsent(level, k -> new AtomicInteger(0)).incrementAndGet();
        });
        return rt;
    }

    public static Set<String> getClusterApplicationNames() {
        HashSet<String> ret = new HashSet<String>(2);
        cache.asMap().forEach((instanceId, level) -> {
            String appName = Instance.getAppNameFromInstanceId((String)instanceId);
            ret.add(appName);
        });
        ret.addAll(ClusterNotifyHealthFactory.getNotifyer().getClusterAppName());
        return ret;
    }
}

