/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.config;

import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class IndicatorConfig {
    private static Log log = LogFactory.getLog(IndicatorConfig.class);
    private static final String SERVICE_HEALTH_DISABLED_INDICATOR = "service.health.disabled.indicators";
    private static Set<String> disableIndicator = new HashSet<String>(2);

    private static void initIndicator() {
        try {
            String s = System.getProperty(SERVICE_HEALTH_DISABLED_INDICATOR, "db");
            if (s != null) {
                HashSet<String> _disableIndicator = new HashSet<String>(2);
                for (String indicator : s.split(",|;")) {
                    _disableIndicator.add(indicator);
                }
                disableIndicator = _disableIndicator;
            }
        }
        catch (Exception e) {
            log.error("init Indicator exception", (Throwable)e);
        }
    }

    public static boolean isDisable(String indicatorname) {
        return disableIndicator.contains(indicatorname);
    }

    static {
        IndicatorConfig.initIndicator();
        ConfigurationUtil.observeChange((String)SERVICE_HEALTH_DISABLED_INDICATOR, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                IndicatorConfig.initIndicator();
            }
        });
    }
}

