/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;
import kd.bos.thread.RunningThreadManage;

public class BackendThreadIndicator
implements Indicator,
IndicatorConfigurable {
    private volatile int runningThreadCount = 0;
    private ItemConfig config = new ItemConfig();

    @Override
    public HealthLevel getHealthLevel() {
        if (this.runningThreadCount <= this.config.normalMaxValue) {
            return HealthLevel.NORMAL;
        }
        if (this.runningThreadCount <= this.config.busyMaxValue) {
            return HealthLevel.BUSY;
        }
        return HealthLevel.OVERLOAD;
    }

    @Override
    public String getName() {
        return "backendthread";
    }

    @Override
    public String getDesc() {
        return "BackendThreadIndicator:" + LangRes.healthmanage.getString("BackendThreadIndicator_3", "Various indicators of active background threads, when the thread count exceeds the threshold, the node is considered busy or overloaded", new Object[0]);
    }

    @Override
    public void touch() {
        this.runningThreadCount = RunningThreadManage.longRunningCount((int)6);
    }

    @Override
    public boolean canResponse() {
        return true;
    }

    @Override
    public boolean isOnlyMservice() {
        return true;
    }

    @Override
    public String getHealthDetail() {
        return "Running Thread Count is [" + this.runningThreadCount + "] ";
    }

    @Override
    public boolean $configEnable() {
        return this.config.isEnable();
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("backendthreadstack");
        return s;
    }

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private int normalMaxValue = 50;
        private int busyMaxValue = 150;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalMaxValue").withDefaultValue(50).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "BackendThreadIndicator_1", "Maximum Threshold for Normal State"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("busyMaxValue").withDefaultValue(150).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "BackendThreadIndicator_2", "Maximum Threshold for Busy State"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }
}

