/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.fullgc.FullGcManage;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.LimitQueue;
import kd.bos.mservice.monitor.assistant.FullGCAssistDiagnose;
import kd.bos.mservice.monitor.healthmanage.config.CommonIndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.config.ConfigItemMeta;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.mservice.monitor.lang.LangSupplier;
import kd.bos.util.JmxUtils;

public class FullGCStatics
implements Indicator,
IndicatorConfigurable {
    private long lastGCTime = 0L;
    private long lastGCTimeIntevel = 0L;
    private LimitQueue<GCInfo> cacheStatus = new LimitQueue(3);
    private final GCInfo EMPTYGCINFO = new GCInfo();
    private long startTime = 0L;
    private boolean isG1 = false;
    private ItemConfig config = new ItemConfig();
    private static Log log = LogFactory.getLog(FullGCStatics.class);

    public FullGCStatics() {
        this.init();
    }

    private void init() {
        try {
            this.startTime = (Long)JmxUtils.getAtt((String)"java.lang:type=Runtime", (String)"StartTime");
            List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
                if (!gcMxBean.getName().contains("G1")) continue;
                this.isG1 = true;
                break;
            }
        }
        catch (Exception e) {
            log.error("init gc type exception", (Throwable)e);
        }
    }

    @Override
    public HealthLevel getHealthLevel() {
        GCInfo curGCInfo = this.getLastFullGCInfo();
        if (this.EMPTYGCINFO.equals(curGCInfo)) {
            return HealthLevel.NORMAL;
        }
        if (FullGcManage.getFullGcOverloadCount() > 3) {
            return HealthLevel.OVERLOAD;
        }
        Long gcEndTime = curGCInfo.getEndTime();
        long gcIntevelMs = System.currentTimeMillis() - gcEndTime;
        if (gcEndTime != this.lastGCTime) {
            this.lastGCTimeIntevel = gcEndTime - this.lastGCTime;
            this.lastGCTime = gcEndTime;
            this.cacheStatus.offer(curGCInfo);
        }
        if (gcIntevelMs < curGCInfo.getDuration()) {
            return HealthLevel.OVERLOAD;
        }
        return gcIntevelMs < (long)this.config.normalGcBefore + curGCInfo.getDuration() ? (this.lastGCTimeIntevel < (long)this.config.overloadGcIntevel ? HealthLevel.OVERLOAD : HealthLevel.BUSY) : HealthLevel.NORMAL;
    }

    public long getLastFullGCTime() {
        GCInfo lastFullGCInfo = this.getLastFullGCInfo();
        long gcEndTime = lastFullGCInfo.getEndTime();
        long lastFullGcTime = System.currentTimeMillis() - gcEndTime;
        return lastFullGcTime;
    }

    private GCInfo getLastFullGCInfo() {
        try {
            if (Boolean.getBoolean("healthactive.fullgc.disable")) {
                return this.EMPTYGCINFO;
            }
            String objectName = this.isG1 ? "java.lang:type=GarbageCollector,name=G1 Old Generation" : "java.lang:type=GarbageCollector,name=PS MarkSweep";
            Object o = JmxUtils.getAtt((String)objectName, (String)"LastGcInfo", (boolean)false);
            if (o == null) {
                return this.EMPTYGCINFO;
            }
            GcInfo gcInfo = GcInfo.from((CompositeData)o);
            Long duration = gcInfo.getDuration();
            Long endTime = gcInfo.getEndTime();
            GCInfo gcinfo = new GCInfo();
            gcinfo.setDuration(duration);
            gcinfo.setEndTime(endTime);
            try {
                gcinfo.parseRecycleInfo(gcInfo);
            }
            catch (Exception e) {
                log.error("parse memory used exception", (Throwable)e);
            }
            return gcinfo;
        }
        catch (Exception e) {
            return this.EMPTYGCINFO;
        }
    }

    @Override
    public String getName() {
        return "fullgc";
    }

    @Override
    public String getDesc() {
        return this.getName() + ":" + LangRes.healthmanage.getString("FullGCStatics_1", "When full GC occurs frequently, the node is considered busy or overloaded", new Object[0]);
    }

    @Override
    public void touch() {
    }

    @Override
    public boolean canResponse() {
        return true;
    }

    @Override
    public boolean isOnlyMservice() {
        return false;
    }

    @Override
    public String getHealthDetail() {
        GCInfo curGCInfo = this.getLastFullGCInfo();
        if (this.EMPTYGCINFO.equals(curGCInfo)) {
            return HealthLevel.NORMAL.toString();
        }
        long cur = System.currentTimeMillis();
        String curStr = FullGCStatics.formatDateTime(cur);
        StringBuilder gcHappened = new StringBuilder();
        StringBuilder gcduration = new StringBuilder();
        for (int size = this.cacheStatus.size() - 1; size >= 0; --size) {
            GCInfo gcinfo = this.cacheStatus.get(size);
            gcHappened.append(FullGCStatics.formatDateTime(gcinfo.endTime)).append(",");
            gcduration.append(gcinfo.duration).append("ms,");
        }
        StringBuilder sb = new StringBuilder(curStr);
        sb.append(" fullgc: happened end at\u3010").append((CharSequence)gcHappened).append(" \u3011\uff0c duration:\u3010").append((CharSequence)gcduration).append("\u3011");
        String ret = sb.toString();
        sb.setLength(0);
        sb.append("\u3010gc begin:").append(FullGCStatics.formatDateTime(curGCInfo.endTime - curGCInfo.duration)).append(" ,").append(" duration:").append(curGCInfo.duration).append("ms \u3011\r\n");
        curGCInfo.mrecycle.forEach((k, v) -> {
            StringBuilder kshow = new StringBuilder((String)k);
            while (kshow.length() < "Compressed Class Space:".length()) {
                kshow.append("  ");
            }
            sb.append((CharSequence)kshow).append(":").append(v);
        });
        FullGCAssistDiagnose.getInstance().setLastGcInfo(sb.toString());
        return ret;
    }

    private static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return FullGCStatics.aliTime((hour + 8L) % 24L) + ":" + FullGCStatics.aliTime(min) + ":" + FullGCStatics.aliTime(s);
    }

    private static String aliTime(long s) {
        if (s < 10L) {
            return "0" + s;
        }
        return "" + s;
    }

    @Override
    public boolean $configEnable() {
        return this.config.isEnable();
    }

    @Override
    public IndicatorItemConfig getIndicatorConfig() {
        return this.config;
    }

    @Override
    public Set<String> getAssistDiagnoseType() {
        HashSet<String> s = new HashSet<String>(2);
        s.add("fullgcinfo");
        s.add("topthread");
        return s;
    }

    private static class ItemConfig
    extends CommonIndicatorItemConfig {
        private int normalGcBefore = 30000;
        private int overloadGcIntevel = 60000;

        private ItemConfig() {
        }

        @Override
        public void initFieldMeta() {
            super.initFieldMeta();
            ConfigItemMeta normalMaxValueFiledMeta = new ConfigItemMeta("normalGcBefore").withDefaultValue(30000).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "FullGCStatics_2", "Threshold for the time elapsed since the last GC completion (ms) (exceeding this is considered normal state)"));
            this.initInfosMap.put(normalMaxValueFiledMeta.getFiledName(), normalMaxValueFiledMeta);
            ConfigItemMeta busyMaxValueFiledMeta = new ConfigItemMeta("overloadGcIntevel").withDefaultValue(60000).withDisplayLabelName(new LangSupplier(LangRes.healthmanage, "FullGCStatics_3", "Time difference between the end of the last two GCs (ms) (below this value is considered overloaded)"));
            this.initInfosMap.put(busyMaxValueFiledMeta.getFiledName(), busyMaxValueFiledMeta);
        }
    }

    static class MemoryRecycle {
        private long max;
        private long useBefore;
        private long after;

        MemoryRecycle() {
        }

        public long getMax() {
            return this.max;
        }

        public void setMax(long max) {
            this.max = max / 0x100000L;
        }

        public long getUseBefore() {
            return this.useBefore;
        }

        public void setUseBefore(long useBefore) {
            this.useBefore = useBefore / 0x100000L;
        }

        public long getAfter() {
            return this.after;
        }

        public void setAfter(long after) {
            this.after = after / 0x100000L;
        }

        public String toString() {
            return String.format("max:%sMB, %sMB -> %s MB  ; \r\n", this.max, this.useBefore, this.after);
        }
    }

    class GCInfo {
        private long duration = 0L;
        private long endTime = 0L;
        private Map<String, MemoryRecycle> mrecycle = new HashMap<String, MemoryRecycle>();

        GCInfo() {
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = FullGCStatics.this.startTime + endTime;
        }

        public void parseRecycleInfo(GcInfo gc) {
            Map<String, MemoryUsage> before = gc.getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> after = gc.getMemoryUsageAfterGc();
            before.forEach((k, v) -> {
                MemoryRecycle re = new MemoryRecycle();
                this.mrecycle.put((String)k, re);
                re.setMax(v.getMax());
                re.setUseBefore(v.getUsed());
                re.setAfter(((MemoryUsage)after.get(k)).getUsed());
            });
        }
    }
}

