/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.indicator;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.UnsupportedDataTypeException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.healthmanage.ServiceHealthIndicatorConfig;
import kd.bos.mservice.monitor.healthmanage.ServiceHealthIndicatorDef;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorConfigurable;
import kd.bos.mservice.monitor.healthmanage.config.IndicatorItemConfig;
import kd.bos.mservice.monitor.healthmanage.indicator.ConfigurationIndicator;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorChain;
import kd.bos.mservice.monitor.items.Indicator;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.WebPortUtil;

public class IndicatorChainImpl
implements IndicatorChain {
    private static final String SERVICE_HEALTH_INDICATORS = "service.health.indicators";
    private static final Log log = LogFactory.getLog(IndicatorChain.class);
    private static final IndicatorChain chain = new IndicatorChainImpl();
    private final Map<String, Indicator> indicators = new ConcurrentHashMap<String, Indicator>(2);
    private final Map<String, Indicator> currentNodeNotNeedIndicators = new ConcurrentHashMap<String, Indicator>(2);

    private IndicatorChainImpl() {
        this.loadIndicator();
    }

    protected static IndicatorChain getInstance() {
        return chain;
    }

    private void loadIndicator() {
        try {
            ServiceHealthIndicatorConfig config = ServiceHealthIndicatorConfig.get();
            if (config != null) {
                List<ServiceHealthIndicatorDef> defs = config.getItems();
                defs.forEach(v -> {
                    ConfigurationIndicator cofigIndicator = new ConfigurationIndicator((ServiceHealthIndicatorDef)v);
                    cofigIndicator.init();
                    this.registeIndicator(cofigIndicator.getName(), cofigIndicator);
                });
            }
            ServiceLoader<Indicator> loader = ServiceLoader.load(Indicator.class);
            Iterator<Indicator> iterator = loader.iterator();
            while (iterator.hasNext()) {
                try {
                    Indicator indicator = iterator.next();
                    this.registeIndicator(indicator.getName(), indicator);
                }
                catch (Error | Exception e) {
                    log.warn("has not indicator ", e);
                }
            }
            if (Boolean.getBoolean("health.indicator.loadfrommc")) {
                this.initIndicators();
            }
        }
        catch (Exception e) {
            log.error("load indicator exception", (Throwable)e);
        }
    }

    private void initIndicators() {
        this.indicators.forEach((key, indicator) -> {
            if (indicator instanceof IndicatorConfigurable) {
                final IndicatorConfigurable ivc = (IndicatorConfigurable)((Object)indicator);
                String name = ivc.getName();
                final String configName = this.getConfigName(name);
                this.parseConfig(this.getConfigValue(configName), ivc);
                ConfigurationUtil.observeChange((String)configName, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                    public void onChange(Object key, Object newValue) {
                        IndicatorChainImpl.this.parseConfig(IndicatorChainImpl.this.getConfigValue(configName), ivc);
                    }
                });
            }
        });
    }

    @Override
    public void configIndicator(String configKey, String configValue) {
        Indicator indicator = this.indicators.get(configKey);
        if (configValue != null && indicator instanceof IndicatorConfigurable) {
            IndicatorConfigurable ivc = (IndicatorConfigurable)((Object)indicator);
            this.parseConfig(configValue, ivc);
        }
    }

    private String getConfigValue(String configName) {
        return System.getProperty(configName);
    }

    private void parseConfig(String configValue, IndicatorConfigurable ivc) {
        if (configValue == null) {
            return;
        }
        System.setProperty(this.getConfigName(ivc.getName()), configValue);
        try {
            Map params = (Map)JSONUtils.cast((String)configValue, Map.class);
            IndicatorItemConfig itemconfig = ivc.getIndicatorConfig();
            Field[] fields = itemconfig.getClass().getDeclaredFields();
            HashSet fset = new HashSet(4);
            Collections.addAll(fset, fields);
            Class<?> superClass = itemconfig.getClass().getSuperclass();
            if (superClass != null) {
                fields = superClass.getDeclaredFields();
                Collections.addAll(fset, fields);
            }
            for (Field field : fset) {
                String fieldName = field.getName();
                Object fieldObj = params.get(fieldName);
                if (fieldObj instanceof String) {
                    String fieldValue = (String)fieldObj;
                    if (fieldValue == null || fieldValue.length() <= 0) continue;
                    Class<?> fieldType = field.getType();
                    field.setAccessible(true);
                    field.set(itemconfig, this.getObject(fieldType, fieldValue));
                    continue;
                }
                if (fieldObj == null) continue;
                field.setAccessible(true);
                field.set(itemconfig, fieldObj);
            }
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException e) {
            log.error("parseConfig params error ,configValue:" + configValue, (Throwable)e);
        }
    }

    private Object getObject(Class<?> fieldType, String fieldValue) throws UnsupportedDataTypeException {
        if (fieldType == Integer.TYPE) {
            return Integer.parseInt(fieldValue);
        }
        if (fieldType == Boolean.TYPE) {
            return Boolean.parseBoolean(fieldValue);
        }
        if (fieldType == String.class) {
            return fieldValue;
        }
        if (fieldType == Double.TYPE) {
            return Double.parseDouble(fieldValue);
        }
        throw new UnsupportedDataTypeException(fieldType.getName());
    }

    private String getConfigName(String name) {
        return "health.indicator." + name;
    }

    private void registeIndicator(String name, Indicator indicator) {
        boolean isNeededIndicator;
        if (Instance.isWebMserviceInOne()) {
            isNeededIndicator = true;
        } else {
            boolean bl = isNeededIndicator = !(WebPortUtil.isWebNode() && indicator.isOnlyMservice() || !WebPortUtil.isWebNode() && indicator.isOnlyWeb());
        }
        if (isNeededIndicator) {
            this.indicators.put(name, indicator);
            System.setProperty(SERVICE_HEALTH_INDICATORS, name + "," + System.getProperty(SERVICE_HEALTH_INDICATORS, ""));
        } else {
            this.currentNodeNotNeedIndicators.put(name, indicator);
        }
    }

    @Override
    public Map<String, Indicator> getIndicators() {
        return Collections.unmodifiableMap(this.indicators);
    }

    @Override
    public Map<String, Indicator> getAllIndicators() {
        ConcurrentHashMap<String, Indicator> allIndicators = new ConcurrentHashMap<String, Indicator>(2);
        allIndicators.putAll(this.indicators);
        allIndicators.putAll(this.currentNodeNotNeedIndicators);
        return Collections.unmodifiableMap(allIndicators);
    }

    @Override
    public void touch() {
        for (Map.Entry<String, Indicator> entry : this.indicators.entrySet()) {
            try {
                Indicator indicator = entry.getValue();
                if (!indicator.isEnable()) continue;
                indicator.touch();
            }
            catch (Exception e) {
                log.error("touch indicator exception", (Throwable)e);
            }
        }
    }
}

