/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.inspect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatistics;
import kd.bos.mservice.monitor.healthmanage.inspect.StatisticsInfo;
import kd.bos.mservice.monitor.healthmanage.inspect.TimeWindow;

public class RpcInvokeStatictics
implements InvokeStatistics {
    private Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, TimeWindow> tpsMap = new ConcurrentHashMap<String, TimeWindow>();
    private AtomicInteger total = new AtomicInteger(0);

    @Override
    public String getName() {
        return "rpc";
    }

    @Override
    public List<StatisticsInfo> statistics() {
        ArrayList<StatisticsInfo> ls = new ArrayList<StatisticsInfo>(2);
        this.tpsMap.forEach((k, v) -> {
            StatisticsInfo sinfo = new StatisticsInfo();
            sinfo.setInstanceid((String)k);
            sinfo.setHosts(ClusterHealth.getInstanceHost(k));
            sinfo.setTps(v.getTps(10));
            ls.add(sinfo);
        });
        return ls;
    }

    @Override
    public void select(String instanceid) {
        if (instanceid == null) {
            return;
        }
        if (this.total.get() > 10000) {
            this.counts.forEach((k, v) -> v.set(0));
            this.total.set(0);
        }
        this.counts.computeIfAbsent(instanceid, k -> new AtomicInteger(0)).incrementAndGet();
        this.total.incrementAndGet();
        if (this.total.get() % 5 == 0) {
            System.setProperty("dubbo.healthloadbalance.least.10000", this.counts.toString());
        }
        this.tpsMap.computeIfAbsent(instanceid, k -> new TimeWindow(1, 60)).incr();
    }

    @Override
    public void invoked(String instanceid) {
    }

    @Override
    public int getTps(String instanceid) {
        TimeWindow tw = this.tpsMap.get(instanceid);
        if (tw != null) {
            return tw.getTps(10);
        }
        return 0;
    }
}

