/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.healthmanage.inspect;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.util.SafeLogUtils;

public class TimeWindow {
    private int minWindowTimeSecond = 1;
    private int windowNumber = 60;
    private LoadingCache<Long, AtomicLong> cache;

    private TimeWindow() {
    }

    public TimeWindow(int minWindowTimeSecond, int windowNumber) {
        this.minWindowTimeSecond = minWindowTimeSecond;
        this.windowNumber = windowNumber;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)(minWindowTimeSecond * (this.windowNumber + 2)), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, AtomicLong>(){

            public AtomicLong load(Long arg0) throws Exception {
                return new AtomicLong(0L);
            }
        });
    }

    public void incr() {
        long curTimeSecondKey = System.currentTimeMillis() / (long)(1000 * this.minWindowTimeSecond);
        try {
            ((AtomicLong)this.cache.get((Object)curTimeSecondKey)).getAndIncrement();
        }
        catch (ExecutionException e) {
            SafeLogUtils.error(TimeWindow.class, (String)"incr errro", (Throwable)e);
        }
    }

    public int getTps(int windowNumber) {
        if (windowNumber == 0) {
            return 0;
        }
        long curSecond = System.currentTimeMillis() / 1000L;
        long curTimeSecondKey = curSecond / (long)this.minWindowTimeSecond - 1L;
        long total = 0L;
        long actNumber = 0L;
        for (int i = 0; i < windowNumber; ++i) {
            AtomicLong ai = (AtomicLong)this.cache.getIfPresent((Object)(curTimeSecondKey - (long)i));
            if (ai == null) continue;
            total += ai.get();
            ++actNumber;
        }
        return (int)(actNumber == 0L ? 0L : total / (actNumber * (long)this.minWindowTimeSecond));
    }
}

