/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.query;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.monitor.healthmanage.config.HealthConfig;
import kd.bos.mservice.monitor.query.HistoryAppHealthData;

public class TotalAppHealthData {
    private String appName;
    private List<HistoryAppHealthData> historyAppHealthDataList = new ArrayList<HistoryAppHealthData>(2);
    private transient Map<Long, HistoryAppHealthData> historyAppHealthDataMap = new ConcurrentHashMap<Long, HistoryAppHealthData>(2);
    private int stepTime = HealthConfig.getBroadcastNotifyInterval() * 2 * 1000;

    public TotalAppHealthData(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public List<HistoryAppHealthData> getHistoryAppHealthDataList() {
        return this.historyAppHealthDataList;
    }

    public HistoryAppHealthData getHistoryAppHealthData(long time) {
        long key = this.getModle(time);
        return this.historyAppHealthDataMap.get(key);
    }

    public void initHistoryAppHealthDatas(Date from, Date to) {
        long fromTime = from.getTime();
        long toTime = to.getTime();
        while ((toTime - fromTime) / (long)this.stepTime > 500L) {
            this.stepTime += 10000;
        }
        long step = this.getStepTime();
        SimpleDateFormat xAxisFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (long i = fromTime; i <= toTime; i += step) {
            long key = this.getModle(i);
            HistoryAppHealthData hahd = new HistoryAppHealthData();
            hahd.setDateTime(xAxisFormat.format(new Date(key * this.getStepTime())));
            this.historyAppHealthDataMap.put(key, hahd);
            this.historyAppHealthDataList.add(hahd);
        }
    }

    private long getModle(long time) {
        return time / this.getStepTime();
    }

    private long getStepTime() {
        return this.stepTime;
    }
}

