/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor.report.pojo;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.govern.ExtensionGovernPoJo;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.HealthLevel;

public class NodeHealthPojo
extends ExtensionGovernPoJo {
    public static final String indexPrefix = Instance.getClusterName() + "-nodehealth-";
    private int healthLevel = -1;
    private long timestamp = System.currentTimeMillis();
    private Map<String, Integer> indicatorLevels = new HashMap<String, Integer>(2);
    private Map<String, String> unnormalIndicatorDescs = new HashMap<String, String>(2);
    private String worstIndicator;
    private static String healthtrace = "non";

    public String getIndexPrefix() {
        return indexPrefix;
    }

    public Map<String, Object> data2map() {
        SimpleDateFormat xAxisFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("appName", Instance.getAppName());
        map.put("instanceId", Instance.getInstanceId());
        map.put("xAxis", xAxisFormat.format(new Date(this.timestamp)));
        map.put("timestamp", this.timestamp);
        map.put("nodeHealthLevel", this.healthLevel);
        if (this.worstIndicator != null) {
            map.put("worstIndicator", this.worstIndicator);
        }
        this.indicatorLevels.forEach((indicatorName, level) -> map.put("indicator.level." + indicatorName, level));
        this.unnormalIndicatorDescs.forEach((indicatorName, dec) -> map.put("indicator.desc." + indicatorName + "", dec));
        if (this.healthLevel >= HealthLevel.OVERLOAD.getLevel()) {
            map.put("healthtrace", healthtrace);
        }
        return map;
    }

    public NodeHealthPojo withNodeHeathLevel(int level) {
        this.healthLevel = level;
        if (level < HealthLevel.OVERLOAD.getLevel()) {
            healthtrace = "non";
        } else if ("non".equals(healthtrace)) {
            healthtrace = "" + new SecureRandom().nextInt(9) + System.currentTimeMillis() % 1000000000L;
        }
        return this;
    }

    public NodeHealthPojo withNodeWorstIndicator(String worstIndicator) {
        this.worstIndicator = worstIndicator;
        return this;
    }

    public void setIndicatorLevel(String indicatorName, int level) {
        this.indicatorLevels.put(indicatorName, level);
    }

    public void setIndicatorDesc(String indicatorName, String dec) {
        this.unnormalIndicatorDescs.put(indicatorName, dec);
    }
}

