/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.sch.PigeonSchService;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.core.support.instance.ServiceEventListener;
import kd.bos.pigeon.core.support.instance.ServiceEventManager;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironment;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentService;
import kd.bos.pigeon.elect.ElectorDTO;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorRole;
import kd.bos.pigeon.elect.ElectorService;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.WebPortUtil;

public class PigeonService
implements Service {
    private static final Log LOGGER = LogFactory.getLog(PigeonService.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"PigeonServiceElectNotify", (int)1);
    private boolean isStarted;
    private static boolean isCandidate = true;

    public String getName() {
        return "PigeonService";
    }

    public void start() {
        this.isStarted = true;
        String mqType = QueueManager.getMQType((String)"demo");
        if (mqType != null && !mqType.equals("pigeon")) {
            return;
        }
        boolean isAppSplit = Instance.isAppSplit();
        if (isAppSplit) {
            if (Instance.getAppIds() == null) {
                isCandidate = false;
                return;
            }
            if (Instance.getAppIds().length > 0 && !Arrays.asList(Instance.getAppIds()).contains("pigeon")) {
                isCandidate = false;
                return;
            }
        } else if (Instance.isStandaloneWebNode()) {
            isCandidate = false;
            return;
        }
        this.initDispatchScheduleEnv();
        Timer timer = new Timer("PigeonServiceInit");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PigeonService.this.waitForServiceReady();
                ServiceInfoManager.initServiceInfoObserver();
                PigeonService.initElector();
                PigeonService.initServiceInfoListener();
            }
        }, PigeonConstant.ELECTOR_WAIT_TIME_VALUE);
    }

    private void waitForServiceReady() {
        String ip = NetAddressUtils.getLocalIpAddress();
        if (NetAddressUtils.isPreferIPv6() && !ip.startsWith("[")) {
            ip = "[" + ip + "]";
        }
        String port = "dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("dubbo.protocol.port", "20880") : ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()) : ("assembly".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("monitor.custom.rpc.port", System.getProperty("dubbo.protocol.port", "20880")) : System.getProperty("monitor.custom.rpc.port", WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()))));
        boolean connectOk = false;
        for (int i = 0; i < 300; ++i) {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(ip, Integer.parseInt(port)), 1000);
                connectOk = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (connectOk) break;
            LockSupport.parkNanos(1000000000L);
        }
    }

    private void initDispatchScheduleEnv() {
        for (DispatchExecutionEnvironmentService tempEnvironmentService : ServiceLoader.load(DispatchExecutionEnvironmentService.class)) {
            DispatchExecutionEnvironment env = new DispatchExecutionEnvironment(tempEnvironmentService.bizType());
            env.setSourceFunctionClass(tempEnvironmentService.sourceFunctionClass());
            env.regist();
        }
    }

    public static void initElector() {
        Elector elector = ElectFactory.getElector((String)("pigeon_elector_" + System.getProperty("mq.debug.queue.tag", "") + System.getProperty("mq.pigeon.local.cluster.tag", "")));
        elector.registerListener((ElectorListener)new /* Unavailable Anonymous Inner Class!! */);
        elector.start();
        ElectorService.startElectorResultNotify();
    }

    public static void initServiceInfoListener() {
        ServiceEventManager.registerListener((String)"pigeon_elector", (ServiceEventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void broadcastSlave(Set<ServiceInfo> slaveServiceSet) {
        if (slaveServiceSet.size() > 0) {
            PigeonRequestContextUtil.createRpcRequestContext();
            ElectorDTO electorDTO = new ElectorDTO.Builder().build();
            electorDTO.setRole(ElectorRole.SLAVE);
            LOGGER.info("ElectorResult,epoch:{},ElectorDTO:{}", (Object)ElectorManager.getCurrEpoch(), (Object)electorDTO);
            for (ServiceInfo tempServiceInfo : slaveServiceSet) {
                try {
                    Object object = EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
                }
                catch (Exception e) {
                    LOGGER.error("broadcastSlaveError", (Throwable)e);
                }
            }
        }
    }

    private static void asyncBroadcastCandidate(Set<ServiceInfo> candidateServiceSet) {
        if (candidateServiceSet.size() > 0) {
            threadPool.execute(() -> {
                PigeonRequestContextUtil.createRpcRequestContext();
                ElectorDTO electorDTO = new ElectorDTO.Builder().build();
                electorDTO.setRole(ElectorRole.CANDIDATE);
                for (ServiceInfo tempServiceInfo : candidateServiceSet) {
                    try {
                        Object object = EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
                    }
                    catch (Exception e) {
                        LOGGER.error("asyncBroadcastCandidateError", (Throwable)e);
                    }
                }
            });
        }
    }

    private static void asyncNotifyCandidate(ServiceInfo candidateService) {
        threadPool.execute(() -> {
            PigeonRequestContextUtil.createRpcRequestContext();
            ElectorDTO electorDTO = new ElectorDTO.Builder().build();
            electorDTO.setRole(ElectorRole.CANDIDATE);
            try {
                Object object = EndPointInvokeServiceHelper.invoke((String)candidateService.getIp(), (String)candidateService.getRpcPort(), (String)"kd.bos.pigeon.elect.ElectorService", (String)"notifyElectorResult", (Object[])new Object[]{electorDTO});
            }
            catch (Exception e) {
                LOGGER.error("asyncNotifyCandidateError", (Throwable)e);
            }
        });
    }

    public void stop() {
        try {
            Collection<PigeonSchService> allBiztypePigeonSchService = PigeonSchService.getAllPigeonSchService();
            List allAccountList = AccountUtils.getAllAccountsOfCurrentEnv();
            for (Account tempAccount : allAccountList) {
                for (PigeonSchService tempPigeonSchService : allBiztypePigeonSchService) {
                    tempPigeonSchService.stopSchByAccountId(tempAccount.getAccountId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("stopError", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    static /* synthetic */ Log access$100() {
        return LOGGER;
    }

    static /* synthetic */ void access$200(Set x0) {
        PigeonService.broadcastSlave(x0);
    }

    static /* synthetic */ void access$300(Set x0) {
        PigeonService.asyncBroadcastCandidate(x0);
    }

    static /* synthetic */ void access$400(ServiceInfo x0) {
        PigeonService.asyncNotifyCandidate(x0);
    }
}

