/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.context;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.dispatch.source.DispatchDataStream;

public class ServiceContext {
    private static final ThreadLocal<ServiceContext> current = new ThreadLocal();
    private String name;
    private IStoreDbConfig storeDbConfig;
    private String tableName;
    private boolean enableBigQueue = true;
    private boolean enableNoConsumerQueue;
    private boolean enableMemCacheQueue = true;
    private DispatchDataStream<PigeonMessageDTO> dispatchDataStream;
    private final Map<String, TaskContext> accountId2taskContextMap = new HashMap<String, TaskContext>();

    public IStoreDbConfig getStoreDbConfig() {
        return this.storeDbConfig;
    }

    public void setStoreDbConfig(IStoreDbConfig storeDbConfig) {
        this.storeDbConfig = storeDbConfig;
    }

    public static ServiceContext getCurrent() {
        return current.get();
    }

    public static void setCurrent(ServiceContext sc) {
        current.set(sc);
    }

    public static void remove() {
        current.remove();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isEnableBigQueue() {
        return this.enableBigQueue;
    }

    public void setEnableBigQueue(boolean enableBigQueue) {
        this.enableBigQueue = enableBigQueue;
    }

    public boolean isEnableNoConsumerQueue() {
        return this.enableNoConsumerQueue;
    }

    public void setEnableNoConsumerQueue(boolean enableNoConsumerQueue) {
        this.enableNoConsumerQueue = enableNoConsumerQueue;
    }

    public boolean isEnableMemCacheQueue() {
        return this.enableMemCacheQueue;
    }

    public void setEnableMemCacheQueue(boolean enableMemCacheQueue) {
        this.enableMemCacheQueue = enableMemCacheQueue;
    }

    public DispatchDataStream<PigeonMessageDTO> getDispatchDataStream() {
        return this.dispatchDataStream;
    }

    public void setDispatchDataStream(DispatchDataStream<PigeonMessageDTO> dispatchDataStream) {
        this.dispatchDataStream = dispatchDataStream;
    }

    public Map<String, TaskContext> getTaskContexts() {
        return this.accountId2taskContextMap;
    }

    public TaskContext getCurrTaskContext() {
        String key = RequestContext.get().getAccountId();
        return this.accountId2taskContextMap.get(key);
    }

    public void notifyToLoadMsg() {
        String key = RequestContext.get().getAccountId();
        TaskContext pc = this.accountId2taskContextMap.get(key);
        pc.getGeneralMsgTask().notify(System.currentTimeMillis());
    }
}

