/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.data.PigeonNoRouteQueueNameWrapper;
import kd.bos.pigeon.core.sch.PigeonSchService;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.helper.QueueTableHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTodoMessageEntityHelper;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.core.support.instance.ServiceEventListener;
import kd.bos.pigeon.core.support.instance.ServiceEventManager;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.core.task.ErrorStatusResetMessageTask;
import kd.bos.pigeon.core.task.RouteMoveMessageTask;
import kd.bos.pigeon.dispatch.source.DispatchDataStream;
import kd.bos.pigeon.dispatch.source.DispatchSourceFunction;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.tenant.TenantInfo;

public class PigeonMessageSource
implements DispatchSourceFunction<PigeonMessageDTO> {
    private static final Log LOGGER = LogFactory.getLog(PigeonMessageSource.class);
    private final AtomicBoolean isRegistServiceInfoListener = new AtomicBoolean(false);
    private final AtomicBoolean isRegistQueueNameListener = new AtomicBoolean(false);
    private String bizType;
    private TenantInfo tenantInfo;
    private Account account;
    private boolean isCancel = false;

    public void init(String bizType, Account account) {
        this.bizType = bizType;
        this.tenantInfo = AccountUtils.getTenantByid((String)account.getTenantId());
        this.account = account;
    }

    public void run(DispatchDataStream<PigeonMessageDTO> stream) {
        PigeonRequestContextUtil.createDbRequestContext((String)this.tenantInfo.getId(), (String)this.account.getAccountId());
        LOGGER.info("tenantId:{},accountId:{} source run...", (Object)this.tenantInfo.getId(), (Object)this.account.getAccountId());
        QueueTableHelper.tableInit();
        PigeonSchService pigeonSchService = PigeonSchService.get(this.bizType);
        pigeonSchService.getServiceContext().setDispatchDataStream(stream);
        pigeonSchService.initSchByAccountId(this.account.getAccountId());
        IStoreDbConfig storeDbConfig = pigeonSchService.getServiceContext().getStoreDbConfig();
        Set dbRouteNoServiceQueueNameSet = QueueTodoMessageEntityHelper.queryDistanctQueueName((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig);
        if (!Instance.isAppSplit()) {
            for (PigeonNoRouteQueueNameWrapper tempRouteNoServiceQueueNameWrapper : dbRouteNoServiceQueueNameSet) {
                String tempQueueName = tempRouteNoServiceQueueNameWrapper.getQueueRealName();
                TaskContext tempTaskContext = pigeonSchService.getServiceContext().getTaskContexts().get(RequestContext.get().getAccountId());
                RouteMoveMessageTask moveMessageTask = new RouteMoveMessageTask(storeDbConfig.getQueueTodoMessageTable(), storeDbConfig.getQueueMessageTable(), tempQueueName);
                tempTaskContext.getOtherTasks().add(moveMessageTask);
                pigeonSchService.submitTask(moveMessageTask);
            }
        } else {
            this.initAppSpiltNoRoute(pigeonSchService, storeDbConfig, dbRouteNoServiceQueueNameSet);
        }
        if (!PigeonConstant.LOCAL_SERVER_STANDALONE) {
            this.registServiceInfoListener();
            this.registCachedQueueNameListener();
        }
    }

    private void initAppSpiltNoRoute(PigeonSchService pigeonSchService, IStoreDbConfig storeDbConfig, Set<PigeonNoRouteQueueNameWrapper> dbRouteNoServiceQueueNameSet) {
        for (PigeonNoRouteQueueNameWrapper tempRouteNoServiceQueueNameWrapper : dbRouteNoServiceQueueNameSet) {
            String tempAppId = tempRouteNoServiceQueueNameWrapper.getAppId();
            String tempQueueName = tempRouteNoServiceQueueNameWrapper.getQueueRealName();
            if (ServiceLookup.hasDeployedAppId((String)tempAppId)) {
                PigeonQueueManager.unmarkNoRouteQueueName((String)tempQueueName);
                TaskContext tempTaskContext = pigeonSchService.getServiceContext().getTaskContexts().get(RequestContext.get().getAccountId());
                RouteMoveMessageTask moveMessageTask = new RouteMoveMessageTask(storeDbConfig.getQueueTodoMessageTable(), storeDbConfig.getQueueMessageTable(), tempQueueName);
                tempTaskContext.getOtherTasks().add(moveMessageTask);
                pigeonSchService.submitTask(moveMessageTask);
                if (PigeonConstant.LOCAL_SERVER_STANDALONE) continue;
                PigeonRequestContextUtil.createRpcRequestContext((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId());
                List<kd.bos.mservice.monitor.ServiceInfo> allServiceInfoList = this.getAllServiceInfoList();
                for (kd.bos.mservice.monitor.ServiceInfo tempServiceInfo : allServiceInfoList) {
                    EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"unmarkNoRouteQueueName", (Object[])new Object[]{tempQueueName});
                }
                continue;
            }
            PigeonQueueManager.markNoRouteQueueName((PigeonNoRouteQueueNameWrapper)tempRouteNoServiceQueueNameWrapper);
            if (PigeonConstant.LOCAL_SERVER_STANDALONE) continue;
            PigeonRequestContextUtil.createRpcRequestContext((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId());
            List<kd.bos.mservice.monitor.ServiceInfo> allServiceInfoList = this.getAllServiceInfoList();
            for (kd.bos.mservice.monitor.ServiceInfo tempServiceInfo : allServiceInfoList) {
                EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceMarkNoRouteQueueName", (Object[])new Object[]{tempRouteNoServiceQueueNameWrapper});
            }
        }
    }

    private void registServiceInfoListener() {
        if (Instance.isAppSplit() && this.isRegistServiceInfoListener.compareAndSet(false, true)) {
            ServiceEventManager.registerListener((String)("pigeon_source_" + this.account.getAccountId()), (ServiceEventListener)new ServiceEventListener(){

                public void serviceUp(ServiceInfo pigeonServiceInfo) {
                    String innerAccountId = PigeonMessageSource.this.account.getAccountId();
                    PigeonRequestContextUtil.createRpcRequestContext((String)AccountUtils.getAccountById((String)innerAccountId).getTenantId(), (String)innerAccountId);
                    LOGGER.info(pigeonServiceInfo.getInstanceId() + " up");
                    String[] upAppIds = pigeonServiceInfo.getAppIds();
                    try {
                        List<String> upAppIdList = Arrays.asList(upAppIds);
                        Collection<PigeonSchService> allBiztypePigeonSchService = PigeonSchService.getAllPigeonSchService();
                        for (PigeonSchService tempPigeonSchService : allBiztypePigeonSchService) {
                            TaskContext tempTaskContext = tempPigeonSchService.getServiceContext().getTaskContexts().get(innerAccountId);
                            if (tempTaskContext == null) continue;
                            for (PigeonNoRouteQueueNameWrapper tempNoRouteQueueNameWrapper : tempTaskContext.getQueueName2noRouteQueueNameWrapperMap().values()) {
                                String tempQueueName = tempNoRouteQueueNameWrapper.getQueueRealName();
                                String tempAppId = tempNoRouteQueueNameWrapper.getAppId();
                                if (!upAppIdList.contains(tempAppId)) continue;
                                PigeonQueueManager.unmarkNoRouteQueueName((String)tempQueueName);
                                IStoreDbConfig storeDbConfig = tempPigeonSchService.getServiceContext().getStoreDbConfig();
                                RouteMoveMessageTask moveMessageTask = new RouteMoveMessageTask(storeDbConfig.getQueueTodoMessageTable(), storeDbConfig.getQueueMessageTable(), tempQueueName);
                                tempTaskContext.getOtherTasks().add(moveMessageTask);
                                tempPigeonSchService.submitTask(moveMessageTask);
                                if (PigeonConstant.LOCAL_SERVER_STANDALONE) continue;
                                List allServiceInfoList = PigeonMessageSource.this.getAllServiceInfoList();
                                for (kd.bos.mservice.monitor.ServiceInfo tempServiceInfo : allServiceInfoList) {
                                    EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"unmarkNoRouteQueueName", (Object[])new Object[]{tempQueueName});
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("PigeonMessageSource#serviceUp error,accountId={},upAppIds={}", new Object[]{innerAccountId, upAppIds, e});
                    }
                }

                public void serviceDown(ServiceInfo pigeonServiceInfo) {
                    String innerAccountId = PigeonMessageSource.this.account.getAccountId();
                    PigeonRequestContextUtil.createDbRequestContext((String)AccountUtils.getAccountById((String)innerAccountId).getTenantId(), (String)innerAccountId);
                    LOGGER.info(pigeonServiceInfo.getInstanceId() + " down");
                    String downInstanceId = pigeonServiceInfo.getInstanceId();
                    try {
                        Collection<PigeonSchService> allBiztypePigeonSchService = PigeonSchService.getAllPigeonSchService();
                        for (PigeonSchService tempPigeonSchService : allBiztypePigeonSchService) {
                            TaskContext tempTaskContext = tempPigeonSchService.getServiceContext().getTaskContexts().get(innerAccountId);
                            if (tempTaskContext == null) continue;
                            ErrorStatusResetMessageTask errorStatusResetMessageTask = new ErrorStatusResetMessageTask(downInstanceId);
                            tempTaskContext.getOtherTasks().add(errorStatusResetMessageTask);
                            tempPigeonSchService.submitTask(errorStatusResetMessageTask);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("PigeonMessageSource#serviceDown error,accountId={},downInstanceId={}", new Object[]{innerAccountId, downInstanceId, e});
                    }
                }
            });
        }
    }

    private void registCachedQueueNameListener() {
        if (this.isRegistQueueNameListener.compareAndSet(false, true)) {
            PigeonQueueManager.registerQueueNameListener((String)("pigeon_source_" + this.account.getAccountId()), (PigeonQueueManager.QueueNameCachedListener)new PigeonQueueManager.QueueNameCachedListener(){

                public void cacheQueueName(String queueName) {
                    String innerAccountId = PigeonMessageSource.this.account.getAccountId();
                    try {
                        PigeonRequestContextUtil.createRpcRequestContext((String)AccountUtils.getAccountById((String)innerAccountId).getTenantId(), (String)innerAccountId);
                        Collection<PigeonSchService> allBiztypePigeonSchService = PigeonSchService.getAllPigeonSchService();
                        for (PigeonSchService tempPigeonSchService : allBiztypePigeonSchService) {
                            TaskContext tempTaskContext = tempPigeonSchService.getServiceContext().getTaskContexts().get(innerAccountId);
                            if (tempTaskContext == null || !tempTaskContext.getNoRouteQueueNameSet().contains(queueName)) continue;
                            LOGGER.info("cacheQueueName:{}", (Object)queueName);
                            PigeonQueueManager.unmarkNoRouteQueueName((String)queueName);
                            IStoreDbConfig storeDbConfig = tempPigeonSchService.getServiceContext().getStoreDbConfig();
                            RouteMoveMessageTask moveMessageTask = new RouteMoveMessageTask(storeDbConfig.getQueueTodoMessageTable(), storeDbConfig.getQueueMessageTable(), queueName);
                            tempTaskContext.getOtherTasks().add(moveMessageTask);
                            tempPigeonSchService.submitTask(moveMessageTask);
                            if (PigeonConstant.LOCAL_SERVER_STANDALONE) continue;
                            List allServiceInfoList = PigeonMessageSource.this.getAllServiceInfoList();
                            for (kd.bos.mservice.monitor.ServiceInfo tempServiceInfo : allServiceInfoList) {
                                EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"unmarkNoRouteQueueName", (Object[])new Object[]{queueName});
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("PigeonMessageSource#cacheQueueName error,accountId={},cacheQueueName={}", new Object[]{innerAccountId, queueName, e});
                    }
                }

                public void removeQueueName(String queueName) {
                }
            });
        }
    }

    private List<kd.bos.mservice.monitor.ServiceInfo> getAllServiceInfoList() {
        ArrayList<kd.bos.mservice.monitor.ServiceInfo> copyAllServiceInfoList = new ArrayList<kd.bos.mservice.monitor.ServiceInfo>(ServiceInfoFactory.get().getServiceList());
        copyAllServiceInfoList.removeIf(tempServiceInfo -> !tempServiceInfo.isGateWay() && ServiceInfoManager.getServiceInfoByInstanceId((String)tempServiceInfo.getInstanceId()) == null);
        return copyAllServiceInfoList;
    }

    public void cancel() {
        this.isCancel = true;
        String accountId = this.account.getAccountId();
        LOGGER.info("tenantId:{},accountId:{} source stop...", (Object)this.tenantInfo.getId(), (Object)this.account.getAccountId());
        PigeonSchService.get(this.bizType).stopSchByAccountId(accountId);
        ServiceEventManager.removeListener((String)("pigeon_source_" + accountId));
        PigeonQueueManager.removeQueueNameListener((String)("pigeon_source_" + accountId));
    }

    static {
        PigeonQueueManager.registerNoRouteQueueNameConsumer((Consumer)new Consumer<PigeonNoRouteQueueNameWrapper>(){

            @Override
            public void accept(PigeonNoRouteQueueNameWrapper noRouteQueueNameWrapper) {
                PigeonSchService tempPigeonSchService = PigeonSchService.get(noRouteQueueNameWrapper.getBizType());
                for (Map.Entry<String, TaskContext> entry : tempPigeonSchService.getServiceContext().getTaskContexts().entrySet()) {
                    entry.getValue().markNoRouteQueueName(noRouteQueueNameWrapper.getQueueRealName(), noRouteQueueNameWrapper);
                }
            }
        });
    }
}

