/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.sch;

import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.sch.PigeonSch;
import kd.bos.pigeon.core.task.BigMessageTask;
import kd.bos.pigeon.core.task.Task;

public class PigeonSchMgr {
    private static final ThreadLocal<PigeonSchMgr> current = new ThreadLocal();
    private final PigeonSch schedule;
    private final ServiceContext serviceContext;

    protected PigeonSchMgr(PigeonSch schedule, ServiceContext serviceContext) {
        this.schedule = schedule;
        this.serviceContext = serviceContext;
    }

    public static PigeonSchMgr getCurrent() {
        return current.get();
    }

    public static void setCurrent(PigeonSchMgr sc) {
        current.set(sc);
    }

    public static void remove() {
        current.remove();
    }

    public TaskContext getTaskContext() {
        String key = RequestContext.get().getAccountId();
        return this.serviceContext.getTaskContexts().get(key);
    }

    public void submitTask(Task task) {
        this.schedule.submit(task, task.getInterval());
    }

    public void removeTask(Task task) {
        this.removeTask(task, null);
    }

    public void removeTask(Task task, Supplier supplier) {
        TaskContext taskContext = this.getTaskContext();
        if (taskContext != null) {
            taskContext.getOtherTasks().remove(task);
            if (supplier != null) {
                supplier.get();
            }
            taskContext.updateQueueStateChangeTime();
        }
        task.setInterval(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBigMsgLoader(String name) {
        TaskContext taskContext = this.getTaskContext();
        if (taskContext == null) {
            return;
        }
        TaskContext taskContext2 = taskContext;
        synchronized (taskContext2) {
            for (Task task : taskContext.getOtherTasks()) {
                if (!(task instanceof BigMessageTask) || !((BigMessageTask)task).getQueueName().equals(name)) continue;
                return;
            }
            BigMessageTask task = new BigMessageTask(name);
            taskContext.getOtherTasks().add(task);
            taskContext.getBigQueueNameSet().add(name);
            taskContext.updateQueueStateChangeTime();
            this.schedule.submit(task, task.getInterval());
        }
    }
}

