/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.sch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.extension.ExtensionFactory;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.sch.PigeonSch;
import kd.bos.pigeon.core.store.cache.PigeonCache;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.task.ClearMessageTask;
import kd.bos.pigeon.core.task.ErrorStatusResetMessageTask;
import kd.bos.pigeon.core.task.GeneralMessageTask;
import kd.bos.pigeon.core.task.Task;
import kd.bos.pigeon.core.task.TaskState;

public class PigeonSchService {
    private static final Map<String, PigeonSchService> bizType2schServiceMap = new ConcurrentHashMap<String, PigeonSchService>(4);
    private final String bizType;
    private PigeonSch MAIN;
    private ServiceContext serviceContext = null;
    private PigeonCache cache = null;

    private PigeonSchService(String bizType) {
        this.bizType = bizType;
    }

    public static PigeonSchService get(String bizType) {
        return bizType2schServiceMap.computeIfAbsent(bizType, key -> {
            PigeonSchService tempPigeonSchService = new PigeonSchService(bizType);
            tempPigeonSchService.initService();
            return tempPigeonSchService;
        });
    }

    public static Collection<PigeonSchService> getAllPigeonSchService() {
        return bizType2schServiceMap.values();
    }

    private void initService() {
        this.serviceContext = new ServiceContext();
        ExtensionFactory storeDbConfigExtensionFactory = ExtensionFactory.getExtensionFacotry(IStoreDbConfig.class);
        IStoreDbConfig storeDbConfig = (IStoreDbConfig)storeDbConfigExtensionFactory.getExtension(this.bizType);
        this.serviceContext.setStoreDbConfig(storeDbConfig);
        this.cache = new PigeonCache();
        this.MAIN = new PigeonSch("pigeon_sch_" + this.bizType, 20, this.serviceContext, this.cache);
    }

    public void initSchByAccountId(String accountId) {
        TaskContext taskContext = this.serviceContext.getTaskContexts().get(accountId);
        if (taskContext == null) {
            TaskContext tmp = new TaskContext();
            this.serviceContext.getTaskContexts().putIfAbsent(accountId, tmp);
            taskContext = this.serviceContext.getTaskContexts().get(accountId);
            if (tmp == taskContext) {
                ErrorStatusResetMessageTask errorStatusResetMessageTask = new ErrorStatusResetMessageTask(null);
                taskContext.getOtherTasks().add(errorStatusResetMessageTask);
                this.MAIN.submit(errorStatusResetMessageTask, errorStatusResetMessageTask.getInterval());
                ClearMessageTask clearMessageTask = new ClearMessageTask();
                taskContext.getOtherTasks().add(clearMessageTask);
                this.MAIN.submit(clearMessageTask, 1);
                GeneralMessageTask generalMessageTask = new GeneralMessageTask();
                taskContext.setGeneralMsgTask(generalMessageTask);
                this.MAIN.submit(generalMessageTask, generalMessageTask.getInterval());
                tmp.setState(TaskState.RUNNING);
            }
        } else {
            TaskState state = taskContext.getState();
            if (state != TaskState.RUNNING && taskContext.cmpAndSetState(state, TaskState.RUNNING)) {
                GeneralMessageTask generalMessageTask = taskContext.getGeneralMsgTask();
                generalMessageTask.setInterval(1);
                if (!generalMessageTask.isSchedule()) {
                    this.MAIN.submit(generalMessageTask, generalMessageTask.getInterval());
                }
            }
        }
    }

    public void stopSchByAccountId(String accountId) {
        TaskContext taskContext = this.serviceContext.getTaskContexts().remove(accountId);
        if (taskContext != null) {
            taskContext.getGeneralMsgTask().setInterval(0);
            for (Task task : taskContext.getOtherTasks()) {
                task.setInterval(0);
            }
            taskContext.setState(TaskState.STOP);
            this.MAIN.removeByAccountId(accountId);
        }
    }

    public void submitTask(Task task) {
        this.MAIN.submit(task, task.getInterval());
    }

    public List<String> getRunningAccountIdList() {
        return new ArrayList<String>(this.serviceContext.getTaskContexts().keySet());
    }

    private boolean checkSch() {
        TaskState state;
        String key = RequestContext.get().getAccountId();
        TaskContext pc = this.serviceContext.getTaskContexts().get(key);
        if (pc != null && (state = pc.getState()) != TaskState.RUNNING && pc.cmpAndSetState(state, TaskState.RUNNING)) {
            GeneralMessageTask task = pc.getGeneralMsgTask();
            task.setInterval(1);
            this.MAIN.submit(task, task.getInterval());
        }
        return pc != null;
    }

    public void notifyToLoadMsg() {
        if (this.checkSch()) {
            this.serviceContext.notifyToLoadMsg();
        }
    }

    public PigeonSch getPigeonSch() {
        return this.MAIN;
    }

    public String getBizType() {
        return this.bizType;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }
}

