/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.context.TaskContext;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.data.PigeonNoRouteQueueNameWrapper;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.MessageTable;
import kd.bos.pigeon.core.task.RouteMoveMessageTask;
import kd.bos.pigeon.core.task.Task;
import kd.bos.pigeon.dispatch.support.DispatchJobResult;
import kd.bos.pigeon.dispatch.support.DispatchJobResultType;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;

public abstract class AbstractDispatchMessageTask
extends Task {
    private final Map<String, AtomicInteger> noConsumerQueueNames2countMap = new HashMap<String, AtomicInteger>();

    protected List<DispatchTaskDTO<PigeonMessageDTO>> filterAndconvertDTOList(List<QueueMessageEntity> entityList) {
        ArrayList<DispatchTaskDTO<PigeonMessageDTO>> dtoList = new ArrayList<DispatchTaskDTO<PigeonMessageDTO>>(entityList.size());
        Date currDate = new Date();
        for (QueueMessageEntity tempMessageEntity : entityList) {
            if (currDate.before(tempMessageEntity.getSchTime())) continue;
            PigeonMessageDTO tempMessageDTO = new PigeonMessageDTO();
            tempMessageDTO.setId(tempMessageEntity.getId());
            tempMessageDTO.setRegion(tempMessageEntity.getRegion());
            tempMessageDTO.setAppId(tempMessageEntity.getAppId());
            tempMessageDTO.setQueueName(tempMessageEntity.getQueueName());
            tempMessageDTO.setSchTime(tempMessageEntity.getSchTime());
            tempMessageDTO.setStatus(tempMessageEntity.getStatus());
            tempMessageDTO.setMessageTable(MessageTable.GENERAL.getDesc());
            DispatchTaskDTO dispatchTaskDTO = new DispatchTaskDTO((Object)tempMessageDTO, tempMessageEntity.getId());
            dispatchTaskDTO.setRegion(tempMessageEntity.getRegion());
            dispatchTaskDTO.setQueueName(tempMessageDTO.getQueueName());
            dispatchTaskDTO.setAppId(tempMessageDTO.getAppId());
            dtoList.add((DispatchTaskDTO<PigeonMessageDTO>)dispatchTaskDTO);
        }
        return dtoList;
    }

    protected void handleDispatchResult(IStoreDbConfig storeDbConfig, DispatchJobResult<PigeonMessageDTO> jobResult) {
        DispatchJobResultType jobResultType = jobResult.getJobResultType();
        if (jobResultType == DispatchJobResultType.ALL) {
            return;
        }
        this.handleFailFilter(storeDbConfig, jobResult);
        this.handleFailRoute(storeDbConfig, jobResult);
        this.handleFailRpc(storeDbConfig, jobResult);
    }

    protected void handleFailFilter(IStoreDbConfig storeDbConfig, DispatchJobResult<PigeonMessageDTO> jobResult) {
    }

    protected void handleFailRoute(IStoreDbConfig storeDbConfig, DispatchJobResult<PigeonMessageDTO> jobResult) {
        DispatchJobResultType jobResultType = jobResult.getJobResultType();
        if (jobResultType == DispatchJobResultType.ALL) {
            return;
        }
        List resultList = jobResult.getResultList();
        HashSet<PigeonNoRouteQueueNameWrapper> noRouteQueueNameWrapperSet = new HashSet<PigeonNoRouteQueueNameWrapper>();
        for (DispatchTaskResultVO tempResultVO : resultList) {
            if (tempResultVO.getFailTranformation() != DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOSERVICE && tempResultVO.getFailTranformation() != DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOCONSUMER) continue;
            String appId = tempResultVO.getDispatchTaskDTO().getAppId();
            String queueName = tempResultVO.getDispatchTaskDTO().getQueueName();
            noRouteQueueNameWrapperSet.add(new PigeonNoRouteQueueNameWrapper(storeDbConfig.bizType(), appId, queueName));
        }
        TaskContext taskContext = ServiceContext.getCurrent().getCurrTaskContext();
        for (PigeonNoRouteQueueNameWrapper tempNoRouteQueueNameWrapper : noRouteQueueNameWrapperSet) {
            String tempQueueName = tempNoRouteQueueNameWrapper.getQueueRealName();
            AtomicInteger count = this.noConsumerQueueNames2countMap.computeIfAbsent(tempQueueName, key -> new AtomicInteger(0));
            count.incrementAndGet();
            if (count.get() < 10 || taskContext.getNoRouteQueueNameSet().contains(tempQueueName)) continue;
            PigeonQueueManager.markNoRouteQueueName((PigeonNoRouteQueueNameWrapper)tempNoRouteQueueNameWrapper);
            List allServiceInfoList = ServiceInfoFactory.get().getServiceList();
            for (ServiceInfo tempServiceInfo : allServiceInfoList) {
                EndPointInvokeServiceHelper.invoke((String)tempServiceInfo.getIp(), (String)tempServiceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceMarkNoRouteQueueName", (Object[])new Object[]{tempNoRouteQueueNameWrapper});
            }
            taskContext.markNoRouteQueueName(tempQueueName, tempNoRouteQueueNameWrapper);
            RouteMoveMessageTask moveMessageTask = new RouteMoveMessageTask(storeDbConfig.getQueueMessageTable(), storeDbConfig.getQueueTodoMessageTable(), tempQueueName);
            taskContext.getOtherTasks().add(moveMessageTask);
            PigeonSchMgr.getCurrent().submitTask(moveMessageTask);
            count.set(0);
        }
    }

    protected void handleFailRpc(IStoreDbConfig storeDbConfig, DispatchJobResult<PigeonMessageDTO> jobResult) {
    }

    private int discardScheduleMsg(IStoreDbConfig storeDbConfig, List<Long> scheduleIdList) {
        return QueueMessageEntityHelper.updateList((IStoreDbConfig)storeDbConfig, scheduleIdList, (String)MessageStatus.DISCARD.getDesc(), null, null);
    }
}

