/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTodoMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.task.Task;
import kd.bos.util.CollectionUtils;

public class ClearMessageTask
extends Task {
    private static final Log LOGGER = LogFactory.getLog(ClearMessageTask.class);

    public ClearMessageTask() {
        this.setInterval(PigeonConstant.MQ_PIGEON_TASK_CLEARMESSAGE_INTERVAL_VALUE);
    }

    @Override
    public void doRun() {
        long startTime = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        Date oneDayAgoDate = calendar.getTime();
        IStoreDbConfig storeDbConfig = ServiceContext.getCurrent().getStoreDbConfig();
        RequestContext requestContext = RequestContext.get();
        int totalDeleteMsgSize = 0;
        for (int i = 0; i < 20; ++i) {
            int deleteMsgSize = 0;
            List messageEntityList = QueueMessageEntityHelper.queryList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)5000, (String[])new String[]{MessageStatus.SUCCESS.getDesc(), MessageStatus.DISCARD.getDesc(), MessageStatus.FAILED.getDesc()});
            if (CollectionUtils.isNotEmpty((Collection)messageEntityList)) {
                ArrayList<Long> idList = new ArrayList<Long>(messageEntityList.size());
                for (QueueMessageEntity tempMessageEntity : messageEntityList) {
                    if (!tempMessageEntity.getSchTime().before(oneDayAgoDate)) continue;
                    idList.add(tempMessageEntity.getId());
                }
                if (idList.size() > 0) {
                    deleteMsgSize = QueueMessageEntityHelper.deleteIdList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, idList);
                }
            }
            if (deleteMsgSize == 0) break;
            totalDeleteMsgSize += deleteMsgSize;
        }
        int deleteTodoMsgSize = QueueTodoMessageEntityHelper.deleteList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (Date)oneDayAgoDate, null);
        long endTime = System.currentTimeMillis();
        LOGGER.info("ClearMessageTaskSuccess,tenantId={},accountId={},deleteMsgSize={},deleteTodoMsgSize={},cost={}", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), totalDeleteMsgSize, deleteTodoMsgSize, endTime - startTime + "ms"});
        this.setInterval(PigeonConstant.MQ_PIGEON_TASK_CLEARMESSAGE_INTERVAL_VALUE);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

