/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.pigeon.core.sch.PigeonSchMgr;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.core.task.Task;
import kd.bos.util.StringUtils;

public class ErrorStatusResetMessageTask
extends Task {
    private static final Log LOGGER = LogFactory.getLog(ErrorStatusResetMessageTask.class);
    private String downInstanceId;

    public ErrorStatusResetMessageTask(String downInstanceId) {
        this.downInstanceId = downInstanceId;
        this.setInterval(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        try {
            IStoreDbConfig storeDbConfig = ServiceContext.getCurrent().getStoreDbConfig();
            RequestContext requestContext = RequestContext.get();
            String[] consumerProcessStatusArray = PigeonConsumerManager.getConsumerProcessStatusArray();
            long startTime = System.currentTimeMillis();
            if (StringUtils.isNotEmpty((String)this.downInstanceId)) {
                int updateSize = QueueMessageEntityHelper.updateList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (String)MessageStatus.READY.getDesc(), (String[])consumerProcessStatusArray, (String)this.downInstanceId);
                long endTime = System.currentTimeMillis();
                LOGGER.info("ErrorStatusResetMessageTaskSuccess,tenantId={},accountId={},updateSize={},downInstanceId={},cost={}", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), updateSize, this.downInstanceId, endTime - startTime + "ms"});
                return;
            }
            Set allServiceInfoSet = ServiceInfoManager.getCopyAllServiceInfoSet();
            Set aliveInstanceIdSet = allServiceInfoSet.stream().map(ServiceInfo::getInstanceId).collect(Collectors.toSet());
            ArrayList<Long> toUpdateStatusIdList = new ArrayList<Long>(100);
            while (true) {
                List messageEntityList = QueueMessageEntityHelper.queryList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)storeDbConfig, (int)5000, (String[])consumerProcessStatusArray, null, null);
                toUpdateStatusIdList.clear();
                for (QueueMessageEntity tempMessageEntity : messageEntityList) {
                    if (aliveInstanceIdSet.contains(tempMessageEntity.getInstanceId())) continue;
                    toUpdateStatusIdList.add(tempMessageEntity.getId());
                }
                if (messageEntityList.size() < 5000 && toUpdateStatusIdList.isEmpty()) {
                    break;
                }
                int updateSize = QueueMessageEntityHelper.updateList((IStoreDbConfig)storeDbConfig, toUpdateStatusIdList, (String)MessageStatus.READY.getDesc(), (String[])consumerProcessStatusArray, null);
                long endTime = System.currentTimeMillis();
                LOGGER.info("ErrorStatusResetMessageTaskSuccess,tenantId={},accountId={},updateSize={},cost={}", new Object[]{requestContext.getTenantId(), requestContext.getAccountId(), updateSize, endTime - startTime + "ms"});
            }
        }
        catch (Exception e) {
            LOGGER.error("ErrorStatusResetMessageTask#run error", (Throwable)e);
        }
        finally {
            PigeonSchMgr.getCurrent().removeTask(this);
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

