/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.task;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.context.ServiceContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;

public abstract class Task
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(Task.class);
    private int interval = 1000;
    private boolean schedule = false;

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isSchedule() {
        return this.schedule;
    }

    public void setSchedule(boolean schedule) {
        this.schedule = schedule;
    }

    public abstract String getName();

    public abstract void doRun();

    @Override
    public void run() {
        try {
            ThreadLifeCycleManager.start();
            String accountId = RequestContext.get().getAccountId();
            if (!ServiceContext.getCurrent().getTaskContexts().containsKey(accountId)) {
                this.interval = 0;
            } else {
                RequestContext.get().setTraceId(TraceIdUtil.createTraceIdString());
                this.doRun();
            }
        }
        catch (Throwable t) {
            LOGGER.error(this.getName() + " run error", t);
        }
        finally {
            ThreadLifeCycleManager.end();
        }
    }
}

