/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.elect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dc.api.model.Account;
import kd.bos.pigeon.elect.AbstractAllocateAccountStrategy;
import kd.bos.pigeon.elect.ElectorNode;

public class AllocateAccountAveragely
extends AbstractAllocateAccountStrategy {
    public static final String NAME = "averagely";

    @Override
    void doAllocate(List<Account> allAccountList, ElectorNode lastMasterNode, Set<ElectorNode> lastSlaveNodeSet, ElectorNode currMasterNode, Set<ElectorNode> currSlaveNodeSet) {
        int nodeSize = 1 + currSlaveNodeSet.size();
        int averageSize = allAccountList.size() / nodeSize;
        int remainderSize = allAccountList.size() % nodeSize;
        ArrayList<ElectorNode> allCurrElectorNode = new ArrayList<ElectorNode>(currSlaveNodeSet.size() + 1);
        allCurrElectorNode.addAll(currSlaveNodeSet);
        allCurrElectorNode.add(currMasterNode);
        int index = 0;
        for (int i = 0; i < allCurrElectorNode.size(); ++i) {
            int count = averageSize + remainderSize;
            List<Account> tempAccountList = allAccountList.subList(index, index + count);
            Map<String, List<Account>> tenantId2accountListMap = this.mergeAccountList(tempAccountList);
            ((ElectorNode)allCurrElectorNode.get(i)).setTenantId2accountListMap(tenantId2accountListMap);
            index += count;
            if (remainderSize == 0) continue;
            --remainderSize;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

