/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.elect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.SysServiceLayerManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.init.MQService;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.elect.ElectorDTO;
import kd.bos.pigeon.elect.ElectorMServiceResponse;
import kd.bos.pigeon.elect.ElectorManager;
import kd.bos.pigeon.elect.ElectorNode;

public class ElectorService {
    private static final Log LOGGER = LogFactory.getLog(ElectorService.class);
    private static final AtomicReference<ElectorDTO> lastNotifyElectorResult = new AtomicReference();
    private static final AtomicBoolean startElectorResultNotify = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startElectorResultNotify() {
        Class<ElectorService> clazz = ElectorService.class;
        synchronized (ElectorService.class) {
            startElectorResultNotify.set(true);
            ElectorDTO electorDTO = lastNotifyElectorResult.getAndSet(null);
            if (electorDTO != null) {
                ElectorService.innerNotifyElectorResult(electorDTO);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElectorMServiceResponse notifyElectorResult(ElectorDTO electorDTO) {
        ElectorMServiceResponse response = new ElectorMServiceResponse();
        response.setReceive(true);
        Class<ElectorService> clazz = ElectorService.class;
        synchronized (ElectorService.class) {
            if (!startElectorResultNotify.get()) {
                LOGGER.info("delay notify elector result");
                lastNotifyElectorResult.set(electorDTO);
            } else {
                ElectorService.innerNotifyElectorResult(electorDTO);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return response;
        }
    }

    private static void innerNotifyElectorResult(ElectorDTO electorDTO) {
        ElectorManager.updateEpoch(electorDTO.getEpoch());
        ElectorManager.updateRole(electorDTO.getRole());
        LOGGER.info("role=" + (Object)((Object)electorDTO.getRole()));
        ElectorDTO.ElectorNodeDTO masterElector = electorDTO.getMaster();
        LOGGER.info("master=" + masterElector);
        boolean isMasterFind = false;
        List<ElectorDTO.ElectorNodeDTO> slaveElectorList = electorDTO.getSlaveList();
        LOGGER.info("slave=" + slaveElectorList);
        HashSet<ElectorNode> slaveNodeSet = new HashSet<ElectorNode>(slaveElectorList.size());
        ServiceInfoManager.syncNotifyUpdateServiceInfo((boolean)false);
        Set allServiceInfoSet = ServiceInfoManager.getCopyAllServiceInfoSet();
        LOGGER.info("allServiceInfoSet=" + allServiceInfoSet);
        for (ServiceInfo tempServiceInfo : allServiceInfoSet) {
            if (!isMasterFind && tempServiceInfo.getInstanceId().equals(masterElector.getInstanceId())) {
                ElectorNode masterNode = new ElectorNode();
                masterNode.setServiceInfo(tempServiceInfo);
                masterNode.setTenantId2accountListMap(ElectorService.mergeAccountList(masterElector.getAccountIdList()));
                ElectorManager.updateMasterNode(masterNode);
                isMasterFind = true;
            }
            for (ElectorDTO.ElectorNodeDTO tempSlaveElector : slaveElectorList) {
                if (!tempServiceInfo.getInstanceId().equals(tempSlaveElector.getInstanceId())) continue;
                ElectorNode electorNode = new ElectorNode();
                electorNode.setServiceInfo(tempServiceInfo);
                electorNode.setTenantId2accountListMap(ElectorService.mergeAccountList(tempSlaveElector.getAccountIdList()));
                slaveNodeSet.add(electorNode);
            }
        }
        LOGGER.info("updateSlaveNodeSet=" + slaveNodeSet);
        ElectorManager.updateSlaveNodeSet(slaveNodeSet);
        ElectorManager.fireElectorResultCallback();
    }

    private static Map<String, List<Account>> mergeAccountList(List<String> accountIdList) {
        if (accountIdList == null) {
            return null;
        }
        HashMap<String, List<Account>> tenantId2accountListMap = new HashMap<String, List<Account>>();
        for (String tempAccountId : accountIdList) {
            Account tempAccount = AccountUtils.getAccountById((String)tempAccountId);
            List accountList = tenantId2accountListMap.computeIfAbsent(tempAccount.getTenantId(), key -> new ArrayList());
            accountList.add(tempAccount);
        }
        return tenantId2accountListMap;
    }

    public static String ping(String instanceId) {
        Service[] sysService = SysServiceLayerManager.loadService();
        boolean mqServiceStarted = false;
        for (Service tempService : sysService) {
            if (!MQService.class.isAssignableFrom(tempService.getClass())) continue;
            mqServiceStarted = tempService.isStarted();
            break;
        }
        if (!mqServiceStarted) {
            return "error";
        }
        if (instanceId.equals(Instance.getInstanceId())) {
            return "pong";
        }
        return "error";
    }
}

