/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nosql.document;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import kd.bos.nosql.TableMeta;
import kd.bos.nosql.document.MongoFilterBuilder;
import kd.bos.nosql.document.MongoStorage;
import kd.bos.nosql.operate.Filter;
import kd.bos.nosql.operate.Filters;
import kd.bos.util.DisCardUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoTableManager {
    public static final String MONGOTABLEMETA = "bos.nosql.mongo.meta";
    private static final String METATABLE = "mongo_meta_table";
    private static final String TABLENAME = "tablename";
    private static final String META = "meta";
    private static Logger logger = Logger.getLogger(MongoTableManager.class);

    private static void init() throws JsonParseException, JsonMappingException, IOException {
        String metaStr = System.getProperty(MONGOTABLEMETA);
        if (StringUtils.isNotEmpty((String)metaStr)) {
            Properties p = new Properties();
            try {
                p.load(new ByteArrayInputStream(metaStr.getBytes(Charsets.UTF_8)));
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            for (Object table : p.keySet()) {
                String mstr = p.getProperty((String)table);
                TableMeta tm = (TableMeta)mapper.readValue(mstr, TableMeta.class);
                MongoTableManager.createTable((String)table, tm);
            }
        }
    }

    protected static void createTable(String tableName, TableMeta m) {
        try (MongoClient mongoClient = MongoTableManager.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(MongoTableManager.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(METATABLE);
            Document doc = new Document();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            doc.append(META, (Object)mapper.writeValueAsString((Object)m)).append(TABLENAME, (Object)tableName);
            long count = collection.count((Bson)new BasicDBObject(TABLENAME, (Object)tableName));
            if (count == 0L) {
                collection.insertOne((Object)doc);
            } else {
                collection.replaceOne((Bson)new BasicDBObject(TABLENAME, (Object)tableName), (Object)doc);
            }
            collection = mongoDatabase.getCollection(tableName);
            List<String> indxs = m.indexs();
            ListIndexesIterable existIndexsItr = collection.listIndexes();
            HashSet<String> existIndexs = new HashSet<String>();
            for (Document d : existIndexsItr) {
                existIndexs.add(d.getString((Object)"name"));
            }
            for (String indexFiled : indxs) {
                if (existIndexs.contains(indexFiled + "_1")) continue;
                collection.createIndex((Bson)new Document(indexFiled, (Object)1));
            }
        }
        catch (IOException e) {
            logger.error((Object)"mongodb createTable error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static TableMeta getMeta(String tableName) {
        try (MongoClient mongoClient = MongoTableManager.getClient();){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(MongoTableManager.getDataBaseName());
            MongoCollection collection = mongoDatabase.getCollection(METATABLE);
            Filter<?> f = Filters.eq(TABLENAME, tableName);
            Document filter = f.build(new MongoFilterBuilder());
            FindIterable findIterable = collection.find((Bson)filter);
            MongoCursor mongoCursor = findIterable.iterator();
            if (!mongoCursor.hasNext()) return null;
            Document d = (Document)mongoCursor.next();
            String metastr = d.getString((Object)META);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            TableMeta tableMeta = (TableMeta)mapper.readValue(metastr, TableMeta.class);
            return tableMeta;
        }
        catch (IOException e) {
            logger.error((Object)"mongodb getMeta error", (Throwable)e);
        }
        return null;
    }

    private static String getDataBaseName() {
        return MongoStorage.instance("").getDataBaseName();
    }

    private static MongoClient getClient() {
        return MongoStorage.instance("").getClient();
    }

    static {
        try {
            MongoTableManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"MongoTableManager init error", (Throwable)e);
        }
    }
}

