/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ha.component;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.ha.component.Counter;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.SlidingWindowCounter;
import org.apache.log4j.Logger;

public class KeepAliveService {
    private static final Logger logger = Logger.getLogger(KeepAliveService.class);
    private static final Map<KeepAliveListener, Counter> aliveListens = new ConcurrentHashMap<KeepAliveListener, Counter>(8);
    private static final Map<KeepAliveListener, Counter> errorListens = new ConcurrentHashMap<KeepAliveListener, Counter>(8);
    private static boolean stop = false;

    public static void start() {
        Thread keepAliveService = new Thread(() -> KeepAliveService.sniffServer());
        keepAliveService.setDaemon(true);
        keepAliveService.setName("KeepAliveService-component");
        keepAliveService.start();
    }

    private static void sniffServer() {
        while (!stop) {
            Set<Map.Entry<KeepAliveListener, Counter>> keepAliveEntrySet = aliveListens.entrySet();
            Iterator<Map.Entry<KeepAliveListener, Counter>> itr = keepAliveEntrySet.iterator();
            while (itr.hasNext()) {
                try {
                    Map.Entry<KeepAliveListener, Counter> keepAliveEntry = itr.next();
                    KeepAliveListener keepAliveListener = keepAliveEntry.getKey();
                    Counter counter = keepAliveEntry.getValue();
                    if (!keepAliveListener.isAvailable()) {
                        counter.addException();
                    }
                    if (counter.hasException()) {
                        keepAliveListener.notifyOffline();
                        ComponentStatusManager.setComponentStatus(keepAliveListener.getUrl(), ComponentStatusManager.ComponentStatus.EXCEPTION);
                        counter.reset();
                        errorListens.putIfAbsent(keepAliveListener, counter);
                        itr.remove();
                    }
                    if (!Boolean.getBoolean("ha.component.redis.debug.enable")) continue;
                    keepAliveListener.notifyOffline();
                    ComponentStatusManager.setComponentStatus(keepAliveListener.getUrl(), ComponentStatusManager.ComponentStatus.EXCEPTION);
                }
                catch (Exception e) {
                    logger.error((Object)"keepAliveListener error in offline: ", (Throwable)e);
                }
            }
            if (Boolean.getBoolean("ha.component.recover.enable")) {
                Iterator<Map.Entry<KeepAliveListener, Counter>> iterator = errorListens.entrySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        Map.Entry<KeepAliveListener, Counter> next = iterator.next();
                        KeepAliveListener keepAliveListener = next.getKey();
                        Counter value = next.getValue();
                        if (!keepAliveListener.isAvailable()) continue;
                        ComponentStatusManager.setComponentStatus(keepAliveListener.getUrl(), ComponentStatusManager.ComponentStatus.NORMAL);
                        keepAliveListener.notifyOnline();
                        value.reset();
                        aliveListens.putIfAbsent(keepAliveListener, value);
                        iterator.remove();
                    }
                    catch (Exception e) {
                        logger.error((Object)"keepAliveListener error in online: ", (Throwable)e);
                    }
                }
            }
            int time = Integer.getInteger("keepalive.sleep.time", 1);
            LockSupport.parkNanos((long)time * 1000000000L);
        }
    }

    public static void registerKeepAliveListener(KeepAliveListener keepAliveListener, Counter counter) {
        aliveListens.putIfAbsent(keepAliveListener, counter);
    }

    public static void registerKeepAliveListener(KeepAliveListener keepAliveListener) {
        KeepAliveService.registerKeepAliveListener(keepAliveListener, new SlidingWindowCounter());
    }
}

