/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.logback.report.IReportFilter;
import kd.bos.logging.logback.report.filter.EmptyReportFilter;
import kd.bos.logging.logback.report.filter.ProxyReportFilter;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportFilterFactory {
    private static Logger logger = LoggerFactory.getLogger(ReportFilterFactory.class);
    private static String EXCEPTION_FILTERS = "audit.exception.report.filters";
    private static List<IReportFilter> filters = new ArrayList<IReportFilter>(4);
    private static IReportFilter filter = null;

    private static void loadFilters(String configfilters) {
        String[] mfilters;
        for (String en : mfilters = configfilters.split(",")) {
            try {
                Class<?> cls = Class.forName(en);
                IReportFilter me = (IReportFilter)cls.newInstance();
                filters.add(me);
            }
            catch (Exception e) {
                logger.error("loadFilters Exception:", (Throwable)e);
            }
        }
    }

    public static IReportFilter getFilter() {
        return filter;
    }

    static {
        try {
            String configfilters = System.getProperty(EXCEPTION_FILTERS);
            if (StringUtils.isEmpty((String)configfilters)) {
                filters.add(new EmptyReportFilter());
            } else {
                ReportFilterFactory.loadFilters(configfilters);
            }
            filter = new ProxyReportFilter(filters);
        }
        catch (Exception t) {
            logger.error("init Exception:", (Throwable)t);
        }
    }
}

