/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report;

import java.util.HashMap;
import java.util.Map;
import kd.bos.instance.Instance;
import kd.bos.logging.logback.report.LogObject;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportObject {
    private static Logger logger = LoggerFactory.getLogger(ReportObject.class);
    private LogObject logObject;
    private Map<String, String> tags = new HashMap<String, String>();
    private String type;

    public ReportObject() {
        this.tags.put("instanceId", Instance.getInstanceId());
    }

    public ReportObject(LogObject logObject) {
        this();
        this.logObject = logObject;
        if (logObject.getLogtags() != null) {
            this.tags.putAll(logObject.getLogtags());
        }
        this.tags.put("methodname", logObject.getMethodName());
        this.tags.put("errormsg", logObject.getMessage());
        this.tags.put("stack", logObject.getStacktrace());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getLogtags() {
        return this.tags;
    }

    public void tag(String key, String value) {
        this.tags.put(key, value);
    }

    public String toJson() {
        Map<String, String> tags = this.getLogtags();
        String billno = null;
        String ver = null;
        String appid = null;
        String formid = null;
        String formname = null;
        String opkey = null;
        String instanceId = null;
        if (tags != null) {
            billno = tags.get("billno");
            ver = tags.get("ver");
            appid = tags.get("appid");
            formid = tags.get("formid");
            formname = tags.get("formname");
            opkey = tags.get("opkey");
            instanceId = tags.get("instanceId");
        }
        billno = billno != null ? billno : "";
        ver = ver != null ? ver : "";
        appid = appid != null ? appid : "";
        formid = formid != null ? formid : "";
        formname = formname != null ? formname : "";
        opkey = opkey != null ? opkey : "";
        HashMap map = new HashMap();
        HashMap<String, String> info = new HashMap<String, String>();
        map.put("data", info);
        info.putAll(tags);
        try {
            return JSONUtils.toString(map);
        }
        catch (Exception e) {
            logger.error("toJson Exception:", (Throwable)e);
            return "";
        }
    }

    public String getFormid() {
        if (this.type == null) {
            return "sty_exception";
        }
        return this.type;
    }

    public String getClusterName() {
        return this.logObject.getClusterName();
    }

    public String getInstanceId() {
        return this.logObject.getInstanceId();
    }

    public String getTime() {
        return this.logObject.getTime();
    }

    public String getLevel() {
        return this.logObject.getLevel();
    }

    public String getClassName() {
        return this.logObject.getClassName();
    }

    public String getMethodName() {
        return this.logObject.getMethodName();
    }

    public int getLine() {
        return this.logObject.getLine();
    }

    public String getMessage() {
        return this.logObject.getMessage();
    }

    public String getAppName() {
        return this.logObject.getAppName();
    }

    public String getIp() {
        return this.logObject.getIp();
    }

    public String getExceptionMessage() {
        return this.logObject.getExceptionMessage();
    }

    public String getExceptionClass() {
        return this.logObject.getExceptionClass();
    }

    public String getStacktrace() {
        return this.logObject.getStacktrace();
    }
}

