/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.logging.logback.report;

import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.logging.logback.report.IReportStore;
import kd.bos.logging.logback.report.ReportObject;
import kd.bos.logging.logback.report.ReportStoreFactory;
import kd.bos.metric.Gauge;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportSender {
    private static Logger logger = LoggerFactory.getLogger(ReportSender.class);
    private static int QUEUE_CAPACITY = 10000;
    private static boolean STOPED = false;
    private static ArrayBlockingQueue<ReportObject> queue = null;
    private static final String config_prefix_key = "metric.exception.report.prefix";
    private static String prefix = "kd.metrics.exception.report.";
    private static Gauge<Integer> queueSize;
    private static Meter discardCount;
    private static boolean async;
    private static IReportStore store;

    private static void init() {
        STOPED = false;
        Thread thread = new Thread((Runnable)new Poll(), "exception-report-pull");
        thread.setDaemon(true);
        thread.start();
        prefix = System.getProperty(config_prefix_key, prefix);
        queueSize = new Gauge<Integer>(){

            public Integer getValue() {
                return queue.size();
            }
        };
        MetricSystem.registerGauge((String)ReportSender.name("queueSize"), queueSize);
        discardCount = MetricSystem.meter((String)ReportSender.name("discardCount"));
    }

    private static String name(String suffix) {
        return prefix + suffix;
    }

    public static void send(ReportObject msg) {
        if (async) {
            boolean success = queue.offer(msg);
            if (!success) {
                discardCount.mark();
            }
        } else {
            store.store(msg);
        }
    }

    public static void stop() {
        STOPED = true;
    }

    static {
        async = true;
        store = ReportStoreFactory.getStore();
        int capacity = ConfigurationUtil.getInteger((String)"audit.exception.report.queue.capacity", (Integer)QUEUE_CAPACITY);
        queue = new ArrayBlockingQueue(capacity);
        String mode = System.getProperty("audit.exception.report.async", "true");
        async = Boolean.parseBoolean(mode);
        if (async) {
            ReportSender.init();
        }
    }

    static class Poll
    implements Runnable {
        Poll() {
        }

        @Override
        public void run() {
            while (!STOPED) {
                try {
                    ReportObject msg = (ReportObject)queue.take();
                    store.store(msg);
                }
                catch (InterruptedException e) {
                    logger.error("run InterruptedException:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("run Exception:", (Throwable)e);
                }
            }
        }
    }
}

